/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.interceptor;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.interceptor.AbstractValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.MetaDataExtractor;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.validation.EmptyValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.NullValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.SkipValidationEvaluator;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class ValidationInterceptor
extends AbstractValidationInterceptor {
    @Override
    protected boolean isRequiredInitializationSupported() {
        return true;
    }

    @Override
    protected void initComponent(FacesContext facesContext, UIComponent uiComponent) {
        this.logger.finest("start to init component " + uiComponent.getClass().getName());
        Map<String, Object> metaDataResult = this.getTransformedMetaDataFor(facesContext, uiComponent);
        if (!metaDataResult.isEmpty()) {
            ExtValUtils.configureComponentWithMetaData(facesContext, uiComponent, metaDataResult);
        }
        this.logger.finest("init component of " + uiComponent.getClass().getName() + " finished");
    }

    protected Map<String, Object> getTransformedMetaDataFor(FacesContext facesContext, UIComponent uiComponent) {
        return ExtValUtils.getTransformedMetaDataFor(facesContext, uiComponent, this.getModuleKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processValidation(FacesContext facesContext, UIComponent uiComponent, Object convertedObject) {
        MetaDataExtractor metaDataExtractor = ExtValUtils.getComponentMetaDataExtractorWith(this.getPropertiesForComponentMetaDataExtractor(uiComponent));
        PropertyInformation propertyInformation = metaDataExtractor.extract(facesContext, uiComponent);
        try {
            this.logger.finest("start validation");
            this.processFieldValidation(facesContext, uiComponent, convertedObject, propertyInformation);
        }
        finally {
            this.logger.finest("validation finished");
        }
    }

    @Override
    protected MetaDataExtractor getComponentMetaDataExtractor(Map<String, Object> properties) {
        return ExtValUtils.getComponentMetaDataExtractorWith(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFieldValidation(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, PropertyInformation propertyInformation) {
        SkipValidationEvaluator skipValidationEvaluator = ExtValContext.getContext().getSkipValidationEvaluator();
        for (MetaDataEntry entry : propertyInformation.getMetaDataEntries()) {
            ValidationStrategy validationStrategy = ExtValUtils.getValidationStrategyForMetaData(entry.getKey());
            if (validationStrategy != null && this.isValidationStrategyCompatibleWithValue(validationStrategy, convertedObject, entry)) {
                if (skipValidationEvaluator.skipValidation(facesContext, uiComponent, validationStrategy, entry)) {
                    this.logger.finest("skip validation of " + entry.getValue() + " with " + validationStrategy.getClass().getName());
                    continue;
                }
                this.logger.finest("validate " + entry.getValue() + " with " + validationStrategy.getClass().getName());
                try {
                    if (entry.getValue() instanceof Annotation && !ExtValUtils.executeLocalBeforeValidationInterceptors(facesContext, uiComponent, convertedObject, PropertyInformation.class.getName(), propertyInformation, entry.getValue(Annotation.class))) continue;
                    validationStrategy.validate(facesContext, uiComponent, entry, convertedObject);
                    continue;
                }
                finally {
                    if (entry.getValue() instanceof Annotation) {
                        ExtValUtils.executeLocalAfterValidationInterceptors(facesContext, uiComponent, convertedObject, PropertyInformation.class.getName(), propertyInformation, entry.getValue(Annotation.class));
                    }
                }
            }
            if (validationStrategy != null) continue;
            this.logger.finest("no validation strategy found for " + entry.getValue());
        }
    }

    protected boolean isValidationStrategyCompatibleWithValue(ValidationStrategy validationStrategy, Object value, MetaDataEntry entry) {
        if (value == null) {
            Class validationStrategyClass = ProxyUtils.getUnproxiedClass(validationStrategy.getClass());
            return validationStrategyClass.isAnnotationPresent(NullValueAwareValidationStrategy.class);
        }
        return !"".equals(value) || ProxyUtils.getUnproxiedClass(validationStrategy.getClass()).isAnnotationPresent(EmptyValueAwareValidationStrategy.class);
    }

    @Override
    protected boolean interpretEmptyStringValuesAsNull() {
        return false;
    }

    @Override
    protected boolean recordProcessedInformation() {
        return true;
    }
}

