/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.storage;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.validator.Validator;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.trinidad.ExtValTrinidadClientValidatorWrapper;
import org.apache.myfaces.extensions.validator.trinidad.storage.TrinidadClientValidatorStorage;

@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultClientValidatorStorage
implements TrinidadClientValidatorStorage {
    private List<UIComponent> componentList = new ArrayList<UIComponent>();

    public void addComponent(UIComponent trinidadComponent) {
        if (!this.componentList.contains(trinidadComponent)) {
            this.componentList.add(trinidadComponent);
        }
    }

    public void rollback() {
        for (UIComponent component : this.componentList) {
            this.removeTrinidadValidatorWrapper(component);
        }
        this.componentList.clear();
    }

    private void removeTrinidadValidatorWrapper(UIComponent uiComponent) {
        if (uiComponent instanceof EditableValueHolder) {
            this.removeWrapperFromComponent(uiComponent);
        } else {
            for (Object child : uiComponent.getChildren()) {
                this.removeTrinidadValidatorWrapper((UIComponent)child);
            }
        }
    }

    private void removeWrapperFromComponent(UIComponent uiComponent) {
        for (Validator validator : ((EditableValueHolder)uiComponent).getValidators()) {
            if (!(validator instanceof ExtValTrinidadClientValidatorWrapper)) continue;
            ((EditableValueHolder)uiComponent).removeValidator(validator);
        }
    }
}

