/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.crossval.annotation.MessageTarget;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCrossValidationStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.ELCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.LocalCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.LocalPropertyChainCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.ReferencingStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public abstract class AbstractCompareStrategy<A extends Annotation>
extends AbstractCrossValidationStrategy {
    protected static List<ReferencingStrategy> referencingStrategies;
    protected Map<Object, Object> violationResultStorage = new HashMap<Object, Object>();

    public AbstractCompareStrategy() {
        this.initReferencingStrategies();
    }

    protected void initReferencingStrategies() {
        if (referencingStrategies == null) {
            referencingStrategies = new ArrayList<ReferencingStrategy>();
            String customReferencingStrategyClassName = ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.BASE_PACKAGE) + "ReferencingStrategy";
            ReferencingStrategy customReferencingStrategy = (ReferencingStrategy)ClassUtils.tryToInstantiateClassForName((String)customReferencingStrategyClassName);
            if (customReferencingStrategy != null) {
                referencingStrategies.add(customReferencingStrategy);
            }
            referencingStrategies.add(new ELCompareStrategy());
            referencingStrategies.add(new LocalCompareStrategy());
            referencingStrategies.add(new LocalPropertyChainCompareStrategy());
        }
    }

    @Override
    public void processCrossValidation(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage) throws ValidatorException {
        String[] validationTargets;
        for (String validationTarget : validationTargets = this.getValidationTargets((Annotation)crossValidationStorageEntry.getMetaDataEntry().getValue())) {
            validationTarget = validationTarget.trim();
            this.tryToValidate(crossValidationStorageEntry, crossValidationStorage, validationTarget);
        }
    }

    private boolean tryToValidate(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String validationTarget) {
        for (ReferencingStrategy referencingStrategy : referencingStrategies) {
            if (!referencingStrategy.evaluateReferenceAndValidate(crossValidationStorageEntry, crossValidationStorage, validationTarget, this)) continue;
            return true;
        }
        return false;
    }

    protected final void processTargetComponentAfterViolation(CrossValidationStorageEntry entryOfSource, CrossValidationStorageEntry entryOfTarget) {
        FacesMessage message;
        if (!this.handleTargetViolation(entryOfSource, entryOfTarget)) {
            if (entryOfTarget == null) {
                this.processTargetComponentAsSourceComponentAfterViolation(entryOfSource);
                return;
            }
            return;
        }
        String summary = this.getErrorMessageSummary((Annotation)entryOfSource.getMetaDataEntry().getValue(), true);
        String details = this.getErrorMessageDetail((Annotation)entryOfSource.getMetaDataEntry().getValue(), true);
        if (entryOfTarget == null) {
            entryOfTarget = entryOfSource;
        }
        if (!((message = entryOfTarget.getMetaDataEntry() != null ? this.getTargetComponentErrorMessage((Annotation)entryOfTarget.getMetaDataEntry().getValue(), summary, details) : this.getTargetComponentErrorMessage((Annotation)entryOfSource.getMetaDataEntry().getValue(), summary, details)).getSummary() == null && message.getDetail() == null || entryOfSource.getClientId() == null || entryOfSource.getClientId().equals(entryOfTarget.getClientId()))) {
            ValidatorException validatorException = new ValidatorException(message);
            boolean isSourceMetaDataUsed = false;
            if (entryOfTarget.getMetaDataEntry() == null) {
                this.prepareTargetMetaDataForSeverityAwareInterception(entryOfSource, entryOfTarget);
                isSourceMetaDataUsed = true;
            }
            if (ExtValUtils.executeAfterThrowingInterceptors((UIComponent)entryOfTarget.getComponent(), (MetaDataEntry)entryOfTarget.getMetaDataEntry(), (Object)entryOfTarget.getConvertedObject(), (ValidatorException)validatorException, (ValidationStrategy)this)) {
                ExtValUtils.tryToAddViolationMessageForComponentId((String)entryOfTarget.getClientId(), (FacesMessage)ExtValUtils.convertFacesMessage((FacesMessage)validatorException.getFacesMessage()));
            }
            if (isSourceMetaDataUsed) {
                this.resetTargetMetaData(entryOfTarget);
            }
        }
    }

    private void prepareTargetMetaDataForSeverityAwareInterception(CrossValidationStorageEntry entryOfSource, CrossValidationStorageEntry entryOfTarget) {
        entryOfTarget.setMetaDataEntry(entryOfSource.getMetaDataEntry());
    }

    private void resetTargetMetaData(CrossValidationStorageEntry entryOfTarget) {
        entryOfTarget.setMetaDataEntry(null);
    }

    private void processTargetComponentAsSourceComponentAfterViolation(CrossValidationStorageEntry entryOfSource) {
        String summary = this.getReverseErrorMessageSummary((Annotation)entryOfSource.getMetaDataEntry().getValue());
        String details = this.getReverseErrorMessageDetail((Annotation)entryOfSource.getMetaDataEntry().getValue());
        FacesMessage message = this.getSourceComponentErrorMessage((Annotation)entryOfSource.getMetaDataEntry().getValue(), summary, details);
        if ((message.getSummary() != null || message.getDetail() != null) && ExtValUtils.executeAfterThrowingInterceptors((UIComponent)entryOfSource.getComponent(), (MetaDataEntry)entryOfSource.getMetaDataEntry(), (Object)entryOfSource.getConvertedObject(), (ValidatorException)new ValidatorException(message), (ValidationStrategy)this)) {
            ExtValUtils.tryToThrowValidatorExceptionForComponent((UIComponent)entryOfSource.getComponent(), (FacesMessage)message, null);
        }
    }

    protected final void processSourceComponentAfterViolation(CrossValidationStorageEntry entryOfSource) {
        if (this.handleSourceViolation(entryOfSource)) {
            String summary = this.getErrorMessageSummary((Annotation)entryOfSource.getMetaDataEntry().getValue(), false);
            String details = this.getErrorMessageDetail((Annotation)entryOfSource.getMetaDataEntry().getValue(), false);
            FacesMessage message = this.getSourceComponentErrorMessage((Annotation)entryOfSource.getMetaDataEntry().getValue(), summary, details);
            if (message.getSummary() != null || message.getDetail() != null) {
                ExtValUtils.tryToThrowValidatorExceptionForComponent((UIComponent)entryOfSource.getComponent(), (FacesMessage)message, null);
            }
        }
        ExtValUtils.tryToThrowValidatorExceptionForComponent((UIComponent)entryOfSource.getComponent(), (FacesMessage)new FacesMessage(FacesMessage.SEVERITY_ERROR, null, null), null);
    }

    protected FacesMessage getSourceComponentErrorMessage(A annotation, String summary, String detail) {
        return ExtValUtils.createFacesMessage((String)summary, (String)detail);
    }

    protected FacesMessage getTargetComponentErrorMessage(A foundAnnotation, String summary, String detail) {
        return ExtValUtils.createFacesMessage((String)summary, (String)detail);
    }

    protected String getErrorMessageSummary(A annotation, boolean isTargetComponent) {
        return this.resolveMessage(this.getValidationErrorMsgKey(annotation, isTargetComponent));
    }

    protected String getErrorMessageDetail(A annotation, boolean isTargetComponent) {
        try {
            String key = this.getValidationErrorMsgKey(annotation, isTargetComponent);
            return key != null ? this.resolveMessage(key + "_detail") : null;
        }
        catch (MissingResourceException e) {
            this.logger.log(Level.WARNING, "couldn't find key " + this.getValidationErrorMsgKey(annotation, isTargetComponent) + "_detail", e);
            return null;
        }
    }

    protected final String getValidationErrorMsgKey(Annotation annotation) {
        return this.getValidationErrorMsgKey(annotation, false);
    }

    protected boolean handleTargetViolation(CrossValidationStorageEntry entryOfSource, CrossValidationStorageEntry entryOfTarget) {
        return entryOfTarget != null && entryOfTarget.getComponent() != null;
    }

    @Deprecated
    protected boolean handleSourceViolation(CrossValidationStorageEntry entryOfSource) {
        return this.useSourceComponentToDisplayErrorMsg(entryOfSource);
    }

    protected boolean useSourceComponentToDisplayErrorMsg(CrossValidationStorageEntry entryOfSource) {
        MessageTarget messageTarget = this.getMessageTarget((Annotation)entryOfSource.getMetaDataEntry().getValue());
        return messageTarget.equals((Object)MessageTarget.source) || messageTarget.equals((Object)MessageTarget.both);
    }

    protected boolean useTargetComponentToDisplayErrorMsg(CrossValidationStorageEntry entryOfSource) {
        MessageTarget messageTarget = this.getMessageTarget((Annotation)entryOfSource.getMetaDataEntry().getValue());
        return messageTarget.equals((Object)MessageTarget.target) || messageTarget.equals((Object)MessageTarget.both);
    }

    protected abstract MessageTarget getMessageTarget(A var1);

    protected String getReverseErrorMessageSummary(A annotation) {
        return this.getErrorMessageSummary(annotation, true);
    }

    protected String getReverseErrorMessageDetail(A annotation) {
        return this.getErrorMessageDetail(annotation, true);
    }

    protected abstract String getValidationErrorMsgKey(A var1, boolean var2);

    public abstract boolean isViolation(Object var1, Object var2, A var3);

    public abstract String[] getValidationTargets(A var1);
}

