/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.extensions.cdi.core.api.activation.ProjectStageActivated;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiCoreConfig;
import org.apache.myfaces.extensions.cdi.core.api.startup.CodiStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.core.api.tools.InvocationOrderComparator;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseListenerExtension
implements Extension {
    private static Map<ClassLoader, List<Class<? extends PhaseListener>>> phaseListeners = new ConcurrentHashMap<ClassLoader, List<Class<? extends PhaseListener>>>();

    public void filterJsfPhaseListeners(@Observes ProcessAnnotatedType processAnnotatedType) {
        CodiStartupBroadcaster.broadcastStartup();
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(JsfPhaseListener.class)) {
            Class phaseListenerClass = processAnnotatedType.getAnnotatedType().getJavaClass();
            if (ClassDeactivation.isClassActivated((Class)phaseListenerClass)) {
                this.addPhaseListener(phaseListenerClass);
            }
            processAnnotatedType.veto();
        }
    }

    private void addPhaseListener(Class<? extends PhaseListener> newPhaseListener) {
        ClassLoader classLoader = PhaseListenerExtension.getClassLoader();
        List<Class<? extends PhaseListener>> phaseListenerClass = phaseListeners.get(classLoader);
        if (phaseListenerClass == null) {
            phaseListenerClass = new CopyOnWriteArrayList<Class<? extends PhaseListener>>();
            phaseListeners.put(classLoader, phaseListenerClass);
        }
        phaseListenerClass.add(newPhaseListener);
    }

    public static List<PhaseListener> consumePhaseListeners() {
        CodiStartupBroadcaster.broadcastStartup();
        ClassLoader classLoader = PhaseListenerExtension.getClassLoader();
        List<Class<? extends PhaseListener>> foundPhaseListeners = phaseListeners.get(classLoader);
        boolean advancedQualifierRequiredForDependencyInjection = ((CodiCoreConfig)CodiUtils.getContextualReferenceByClass(CodiCoreConfig.class, (Annotation[])new Annotation[0])).isAdvancedQualifierRequiredForDependencyInjection();
        if (foundPhaseListeners != null && !foundPhaseListeners.isEmpty()) {
            ArrayList<PhaseListener> result = new ArrayList<PhaseListener>(foundPhaseListeners.size());
            Class<?> activeProjectStage = ProjectStageProducer.getInstance().getProjectStage().getClass();
            for (Class<? extends PhaseListener> phaseListenerClass : foundPhaseListeners) {
                if (phaseListenerClass.isAnnotationPresent(ProjectStageActivated.class)) {
                    boolean projectStageFound = false;
                    for (Class currentProjectStage : phaseListenerClass.getAnnotation(ProjectStageActivated.class).value()) {
                        if (!currentProjectStage.isAssignableFrom(activeProjectStage)) continue;
                        projectStageFound = true;
                    }
                    if (!projectStageFound) continue;
                }
                PhaseListener phaseListener = PhaseListenerExtension.createPhaseListenerInstance(phaseListenerClass);
                result.add((PhaseListener)CodiUtils.injectFields((Object)phaseListener, (boolean)advancedQualifierRequiredForDependencyInjection));
            }
            foundPhaseListeners.clear();
            Collections.sort(result, new InvocationOrderComparator());
            return result;
        }
        return Collections.emptyList();
    }

    private static PhaseListener createPhaseListenerInstance(Class<? extends PhaseListener> phaseListenerClass) {
        return (PhaseListener)ClassUtils.tryToInstantiateClass(phaseListenerClass);
    }

    private static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null);
    }
}

