/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.ListenersFor;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.model.FacesDataModel;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.webapp.DelegatedFacesServlet;
import org.apache.myfaces.webapp.MyFacesHttpSessionListener;

@HandlesTypes(value={FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, FacesDataModel.class, ListenerFor.class, ListenersFor.class, NamedEvent.class, ResourceDependencies.class, ResourceDependency.class, UIComponent.class, Converter.class, Renderer.class, Validator.class})
public class MyFacesContainerInitializer
implements ServletContainerInitializer {
    public static final String FACES_SERVLET_ADDED_ATTRIBUTE = "org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET";
    public static final String FACES_SERVLET_FOUND = "org.apache.myfaces.FACES_SERVLET_FOUND";
    public static final String FACES_SERVLET_SERVLETREGISTRATION = "org.apache.myfaces.FACES_SERVLET_SERVLETREGISTRATION";
    private static final String FACES_CONFIG_RESOURCE = "/WEB-INF/faces-config.xml";
    private static final Logger log = Logger.getLogger(MyFacesContainerInitializer.class.getName());
    private static final String[] FACES_SERVLET_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces"};
    private static final String[] FACES_SERVLET_FULL_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces", "*.xhtml"};
    private static final String FACES_SERVLET_NAME = "FacesServlet";
    private static final Class<? extends Servlet> FACES_SERVLET_CLASS = FacesServlet.class;
    private static final Class<?> DELEGATED_FACES_SERVLET_CLASS = DelegatedFacesServlet.class;

    @Override
    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        log.log(Level.INFO, "Using " + this.getClass().getName());
        MyFacesHttpSessionListener httpSessionListener = new MyFacesHttpSessionListener();
        servletContext.addListener(httpSessionListener);
        servletContext.setAttribute(MyFacesHttpSessionListener.APPLICATION_MAP_KEY, httpSessionListener);
        boolean startDireclty = this.shouldStartupRegardless(servletContext);
        if (startDireclty) {
            return;
        }
        boolean isFacesServletPresent = this.checkForFacesServlet(servletContext);
        if ((clazzes != null && !clazzes.isEmpty() || this.isFacesConfigPresent(servletContext)) && !isFacesServletPresent) {
            Object[] mappings;
            ServletRegistration.Dynamic servlet = servletContext.addServlet(FACES_SERVLET_NAME, FACES_SERVLET_CLASS);
            Set<String> conflictMappings = servlet.addMapping((String[])(mappings = this.isAutomaticXhtmlMappingDisabled(servletContext) ? FACES_SERVLET_MAPPINGS : FACES_SERVLET_FULL_MAPPINGS));
            if (conflictMappings != null && !conflictMappings.isEmpty()) {
                HashSet<String> newMappings = new HashSet<String>(Arrays.asList(mappings));
                newMappings.removeAll(conflictMappings);
                mappings = newMappings.toArray(new String[newMappings.size()]);
                servlet.addMapping((String[])mappings);
            }
            if (mappings != null && mappings.length > 0) {
                servletContext.setAttribute(FACES_SERVLET_ADDED_ATTRIBUTE, Boolean.TRUE);
                servletContext.setAttribute(FACES_SERVLET_SERVLETREGISTRATION, servlet);
                log.log(Level.INFO, "Added FacesServlet with mappings=" + Arrays.toString(mappings));
            }
        }
    }

    private boolean shouldStartupRegardless(ServletContext servletContext) {
        try {
            String standaloneStartup = servletContext.getInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE");
            return "true".equalsIgnoreCase(standaloneStartup);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean shouldSkipJarFacesConfigScan(ServletContext servletContext) {
        try {
            String skipJarScan = servletContext.getInitParameter("org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN");
            if (skipJarScan == null) {
                skipJarScan = System.getProperty("org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN");
            }
            return "true".equalsIgnoreCase(skipJarScan);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isAutomaticXhtmlMappingDisabled(ServletContext servletContext) {
        try {
            String xhtmlMappingDisabled = servletContext.getInitParameter("jakarta.faces.DISABLE_FACESSERVLET_TO_XHTML");
            if (xhtmlMappingDisabled == null) {
                xhtmlMappingDisabled = "false";
            }
            return "true".equalsIgnoreCase(xhtmlMappingDisabled);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFacesConfigPresent(ServletContext servletContext) {
        try {
            StartupServletExternalContextImpl externalContext;
            FacesConfigResourceProviderFactory factory;
            FacesConfigResourceProvider provider;
            Collection<URL> metaInfFacesConfigUrls;
            if (servletContext.getResource(FACES_CONFIG_RESOURCE) != null) {
                return true;
            }
            String configFilesAttrValue = servletContext.getInitParameter("jakarta.faces.CONFIG_FILES");
            if (configFilesAttrValue != null) {
                String[] configFiles;
                for (String file : configFiles = configFilesAttrValue.split(",")) {
                    if (servletContext.getResource(file.trim()) == null) continue;
                    return true;
                }
            }
            return !this.shouldSkipJarFacesConfigScan(servletContext) && (metaInfFacesConfigUrls = (provider = (factory = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext = new StartupServletExternalContextImpl(servletContext, true))).createFacesConfigResourceProvider(externalContext)).getMetaInfConfigurationResources(externalContext)) != null && !metaInfFacesConfigUrls.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkForFacesServlet(ServletContext servletContext) {
        Map<String, ? extends ServletRegistration> servlets = servletContext.getServletRegistrations();
        boolean isFacesServletPresent = false;
        for (Map.Entry<String, ? extends ServletRegistration> servletEntry : servlets.entrySet()) {
            String className = servletEntry.getValue().getClassName();
            if (!FACES_SERVLET_CLASS.getName().equals(className) && !this.isDelegatedFacesServlet(className)) continue;
            servletContext.setAttribute(FACES_SERVLET_FOUND, Boolean.TRUE);
            isFacesServletPresent = true;
            servletContext.setAttribute(FACES_SERVLET_SERVLETREGISTRATION, servletEntry.getValue());
        }
        return isFacesServletPresent;
    }

    private boolean isDelegatedFacesServlet(String className) {
        if (className == null) {
            return false;
        }
        try {
            Class clazz = ClassUtils.classForName(className);
            return DELEGATED_FACES_SERVLET_CLASS.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }
}

