/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared.lang;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.lang.LambdaPropertyDescriptor;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorWrapper;

public class PropertyDescriptorUtils {
    private static final Logger LOG = Logger.getLogger(PropertyDescriptorUtils.class.getName());
    public static final String USE_LAMBDA_METAFACTORY = "org.apache.myfaces.USE_LAMBDA_METAFACTORY";
    private static final String CACHE_KEY = PropertyDescriptorUtils.class.getName() + ".CACHE";
    private static Method privateLookupIn;

    private static Map<String, Map<String, ? extends PropertyDescriptorWrapper>> getCache(ExternalContext ec) {
        ConcurrentHashMap cache = (ConcurrentHashMap)ec.getApplicationMap().get(CACHE_KEY);
        if (cache == null) {
            cache = new ConcurrentHashMap(1000);
            ec.getApplicationMap().put(CACHE_KEY, cache);
        }
        return cache;
    }

    public static Map<String, ? extends PropertyDescriptorWrapper> getCachedPropertyDescriptors(ExternalContext ec, Class<?> target) {
        Map cache = PropertyDescriptorUtils.getCache(ec).get(target.getName());
        if (cache == null) {
            cache = PropertyDescriptorUtils.getCache(ec).computeIfAbsent(target.getName(), k -> PropertyDescriptorUtils.getPropertyDescriptors(ec, target));
        }
        return cache;
    }

    public static boolean isUseLambdaMetafactory(ExternalContext ec) {
        if (privateLookupIn == null) {
            return false;
        }
        String useMethodHandles = ec.getInitParameter(USE_LAMBDA_METAFACTORY);
        return useMethodHandles == null || useMethodHandles.trim().isEmpty() || useMethodHandles.contains("true");
    }

    public static Map<String, ? extends PropertyDescriptorWrapper> getPropertyDescriptors(ExternalContext ec, Class<?> target) {
        if (PropertyDescriptorUtils.isUseLambdaMetafactory(ec)) {
            try {
                return PropertyDescriptorUtils.getLambdaPropertyDescriptors(target);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.FINEST, "Could not generate LambdaPropertyDescriptor for " + target.getName() + ". Use PropertyDescriptor...");
            }
            catch (Throwable e) {
                LOG.log(Level.INFO, "Could not generate LambdaPropertyDescriptor for " + target.getName() + ". Use PropertyDescriptor...", e);
            }
        }
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(target).getPropertyDescriptors();
            ConcurrentHashMap<String, PropertyDescriptorWrapper> map = new ConcurrentHashMap<String, PropertyDescriptorWrapper>(propertyDescriptors.length);
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                map.put(propertyDescriptor.getName(), new PropertyDescriptorWrapper(target, propertyDescriptor));
            }
            return map;
        }
        catch (IntrospectionException e) {
            throw new FacesException(e);
        }
    }

    public static LambdaPropertyDescriptor getLambdaPropertyDescriptor(Class<?> target, String name) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(target).getPropertyDescriptors();
            if (propertyDescriptors == null || propertyDescriptors.length == 0) {
                return null;
            }
            for (PropertyDescriptor pd : propertyDescriptors) {
                if (!name.equals(pd.getName())) continue;
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, target, MethodHandles.lookup());
                return PropertyDescriptorUtils.createLambdaPropertyDescriptor(target, pd, lookup);
            }
            throw new FacesException("Property \"" + name + "\" not found on \"" + target.getName() + "\"");
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    public static LambdaPropertyDescriptor createLambdaPropertyDescriptor(Class<?> target, PropertyDescriptor pd, MethodHandles.Lookup lookup) throws Throwable {
        Method writeMethod;
        if (pd.getPropertyType() == null) {
            return null;
        }
        LambdaPropertyDescriptor lpd = new LambdaPropertyDescriptor(target, pd);
        Method readMethod = pd.getReadMethod();
        if (readMethod != null) {
            MethodHandle handle = lookup.unreflect(readMethod);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), handle, handle.type());
            lpd.readFunction = callSite.getTarget().invokeExact();
        }
        if ((writeMethod = pd.getWriteMethod()) != null) {
            MethodHandle handle = lookup.unreflect(writeMethod);
            lpd.writeFunction = PropertyDescriptorUtils.createSetter(lookup, lpd, handle);
        }
        return lpd;
    }

    public static Map<String, PropertyDescriptorWrapper> getLambdaPropertyDescriptors(Class<?> target) throws Throwable {
        PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(target).getPropertyDescriptors();
        if (propertyDescriptors == null || propertyDescriptors.length == 0) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, PropertyDescriptorWrapper> properties = new ConcurrentHashMap<String, PropertyDescriptorWrapper>(propertyDescriptors.length);
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, target, MethodHandles.lookup());
        for (PropertyDescriptor pd : Introspector.getBeanInfo(target).getPropertyDescriptors()) {
            PropertyDescriptorWrapper wrapped = PropertyDescriptorUtils.createLambdaPropertyDescriptor(target, pd, lookup);
            if (wrapped == null) {
                wrapped = new PropertyDescriptorWrapper(target, pd);
            }
            properties.put(pd.getName(), wrapped);
        }
        return properties;
    }

    protected static BiConsumer createSetter(MethodHandles.Lookup lookup, LambdaPropertyDescriptor propertyInfo, MethodHandle setterHandle) throws LambdaConversionException, Throwable {
        Class<?> propertyType = propertyInfo.getPropertyType();
        if (propertyType.isPrimitive()) {
            if (propertyType == Double.TYPE) {
                ObjDoubleConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjDoubleConsumer.class, Double.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Double)b);
            }
            if (propertyType == Integer.TYPE) {
                ObjIntConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjIntConsumer.class, Integer.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Integer)b);
            }
            if (propertyType == Long.TYPE) {
                ObjLongConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjLongConsumer.class, Long.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Long)b);
            }
            if (propertyType == Float.TYPE) {
                ObjFloatConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjFloatConsumer.class, Float.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, ((Float)b).floatValue());
            }
            if (propertyType == Byte.TYPE) {
                ObjByteConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjByteConsumer.class, Byte.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Byte)b);
            }
            if (propertyType == Character.TYPE) {
                ObjCharConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjCharConsumer.class, Character.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, ((Character)b).charValue());
            }
            if (propertyType == Short.TYPE) {
                ObjShortConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjShortConsumer.class, Short.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Short)b);
            }
            if (propertyType == Boolean.TYPE) {
                ObjBooleanConsumer consumer = PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, ObjBooleanConsumer.class, Boolean.TYPE).getTarget().invokeExact();
                return (a, b) -> consumer.accept(a, (Boolean)b);
            }
            throw new RuntimeException("Type is not supported yet: " + propertyType.getName());
        }
        return PropertyDescriptorUtils.createSetterCallSite(lookup, setterHandle, BiConsumer.class, Object.class).getTarget().invokeExact();
    }

    protected static CallSite createSetterCallSite(MethodHandles.Lookup lookup, MethodHandle setter, Class<?> interfaceType, Class<?> valueType) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(interfaceType), MethodType.methodType(Void.TYPE, Object.class, valueType), setter, setter.type());
    }

    static {
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface ObjBooleanConsumer<T> {
        public void accept(T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ObjShortConsumer<T> {
        public void accept(T var1, short var2);
    }

    @FunctionalInterface
    public static interface ObjCharConsumer<T> {
        public void accept(T var1, char var2);
    }

    @FunctionalInterface
    public static interface ObjByteConsumer<T> {
        public void accept(T var1, byte var2);
    }

    @FunctionalInterface
    public static interface ObjFloatConsumer<T> {
        public void accept(T var1, float var2);
    }
}

