/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectBoolean;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlSelectBooleanCheckbox;
import jakarta.faces.component.html.HtmlSelectManyCheckbox;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlCheckboxRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlCheckboxRendererBase.class.getName());
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String LAYOUT_LIST = "list";
    private static final String EXTERNAL_TRUE_VALUE = "true";

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Map behaviors;
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (uiComponent instanceof UISelectBoolean) {
            Boolean value = RendererUtils.getBooleanValue(uiComponent);
            boolean isChecked = value != null ? value : false;
            this.renderCheckbox(facesContext, uiComponent, EXTERNAL_TRUE_VALUE, false, isChecked, true, null);
        } else if (uiComponent instanceof UISelectMany) {
            log.finest("encodeBegin() doing nothing intentionally for UISelectMany");
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof UISelectBoolean) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.endElement("input");
        } else if (uiComponent instanceof UISelectMany) {
            this.renderCheckboxList(facesContext, (UISelectMany)uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        Converter converter;
        Set lookupSet;
        boolean useSubmittedValues;
        String layout = this.getLayout(selectMany);
        Boolean usingTable = Boolean.FALSE;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                usingTable = Boolean.TRUE;
            } else if (layout.equals(LINE_DIRECTION)) {
                usingTable = Boolean.FALSE;
            } else if (layout.equals(LAYOUT_LIST)) {
                usingTable = null;
            } else {
                log.severe("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout);
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(usingTable != null ? "table" : "ul", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        Map behaviors = null;
        if (selectMany instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)selectMany).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", (Object)selectMany.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        }
        if (usingTable == Boolean.FALSE) {
            writer.startElement("tr", null);
        }
        boolean bl = useSubmittedValues = (lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter = this.getConverter(facesContext, (UIComponent)selectMany), selectMany)) != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        int itemNum = 0;
        List<SelectItem> selectItemList = RendererUtils.getSelectItemList(selectMany, facesContext);
        for (int i = 0; i < selectItemList.size(); ++i) {
            SelectItem selectItem = selectItemList.get(i);
            itemNum = this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, useSubmittedValues, lookupSet, converter, usingTable, itemNum);
        }
        if (usingTable == Boolean.FALSE) {
            writer.endElement("tr");
        }
        writer.endElement(usingTable != null ? "table" : "ul");
    }

    protected String getLayout(UISelectMany selectMany) {
        if (selectMany instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)selectMany).getLayout();
        }
        return (String)selectMany.getAttributes().get("layout");
    }

    protected int renderGroupOrItemCheckbox(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean useSubmittedValues, Set lookupSet, Converter converter, Boolean usingTable, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectMany selectMany = (UISelectMany)uiComponent;
        if (isSelectItemGroup) {
            SelectItem[] selectItems;
            if (usingTable == Boolean.TRUE) {
                writer.startElement("tr", null);
            }
            writer.startElement(usingTable != null ? "td" : "li", null);
            if (selectItem.isEscape()) {
                writer.writeText((Object)selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement(usingTable != null ? "td" : "li");
            if (usingTable == Boolean.TRUE) {
                writer.endElement("tr");
                writer.startElement("tr", null);
            }
            writer.startElement(usingTable != null ? "td" : "li", null);
            writer.startElement(usingTable != null ? "table" : "ul", null);
            if (usingTable != null) {
                int border = 0;
                Object borderObj = uiComponent.getAttributes().get("border");
                if (null != borderObj) {
                    border = (Integer)borderObj;
                }
                if (Integer.MIN_VALUE != border) {
                    writer.writeAttribute("border", (Object)border, "border");
                }
            }
            if (usingTable == Boolean.FALSE) {
                writer.startElement("tr", null);
            }
            SelectItemGroup group = (SelectItemGroup)selectItem;
            for (SelectItem groupSelectItem : selectItems = group.getSelectItems()) {
                itemNum = this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, groupSelectItem, useSubmittedValues, lookupSet, converter, usingTable, itemNum);
            }
            if (usingTable == Boolean.FALSE) {
                writer.endElement("tr");
            }
            writer.endElement(usingTable != null ? "table" : "ul");
            writer.endElement(usingTable != null ? "td" : "li");
            if (usingTable == Boolean.TRUE) {
                writer.endElement("tr");
            }
        } else {
            Object itemValue = selectItem.getValue();
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectMany, converter, itemValue);
            boolean checked = lookupSet.contains(itemStrValue);
            if (HtmlRendererUtils.isHideNoSelectionOption(uiComponent) && selectItem.isNoSelectionOption() && !lookupSet.isEmpty() && !checked) {
                return itemNum;
            }
            writer.write("\t\t");
            if (usingTable == Boolean.TRUE) {
                writer.startElement("tr", null);
            }
            writer.startElement(usingTable != null ? "td" : "li", null);
            boolean disabled = selectItem.isDisabled();
            String itemId = this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, disabled, checked, false, itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectMany);
            boolean itemDisabled = componentDisabled || disabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectMany, itemId, selectItem, itemDisabled, checked);
            writer.endElement(usingTable != null ? "td" : "li");
            if (usingTable == Boolean.TRUE) {
                writer.endElement("tr");
            }
            Integer n = itemNum;
            Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
        }
        return itemNum;
    }

    protected String renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + facesContext.getNamingContainerSeparatorChar() + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        Map behaviors = null;
        if (uiComponent instanceof UISelectBoolean) {
            if (uiComponent instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
                    CommonHtmlAttributesUtil.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                    CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                    CommonHtmlAttributesUtil.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, uiComponent);
                } else {
                    long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
                    HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                        long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(uiComponent);
                        CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                        CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    } else {
                        HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                        HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    }
                }
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
            }
        } else if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
                CommonHtmlAttributesUtil.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, uiComponent);
            } else {
                long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(uiComponent);
                    CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                }
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (uiComponent instanceof UISelectMany) {
            writer.endElement("input");
        }
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlSelectBooleanCheckbox) {
            return ((HtmlSelectBooleanCheckbox)component).isDisabled();
        }
        if (component instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)component).isDisabled();
        }
        return AttributeUtils.getBooleanAttribute((UIComponent)component, (String)"disabled", (boolean)false);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            HtmlRendererUtils.decodeUISelectBoolean(facesContext, component);
        } else if (component instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            return submittedValue;
        }
        if (component instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)component, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
    }

    protected Converter getConverter(FacesContext facesContext, UIComponent component) {
        if (component instanceof UISelectMany) {
            return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, (UIComponent)((UISelectMany)component));
        }
        if (component instanceof UISelectOne) {
            return HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, component);
        }
        return null;
    }
}

