/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.converter;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.convert.Converter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.converter.FacesConverterAnnotationLiteral;
import org.apache.myfaces.cdi.converter.FacesConverterInfo;
import org.apache.myfaces.cdi.util.AbstractDynamicProducer;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class FacesConverterProducer
extends AbstractDynamicProducer<Converter> {
    public FacesConverterProducer(BeanManager beanManager, FacesConverterInfo typeInfo) {
        super(beanManager);
        String forClass = typeInfo.getForClass() == null ? "" : (typeInfo.getForClass() == Object.class ? "" : typeInfo.getForClass().getName());
        String converterId = typeInfo.getConverterId() == null ? "" : typeInfo.getConverterId();
        String id = "" + typeInfo.getType() + "_" + forClass + "_" + converterId;
        FacesConverterAnnotationLiteral literal = new FacesConverterAnnotationLiteral(typeInfo.getForClass() == null ? Object.class : typeInfo.getForClass(), typeInfo.getConverterId() == null ? "" : typeInfo.getConverterId(), true);
        super.id(id).scope(Dependent.class).qualifiers(new Annotation[]{literal}).types(new Type[]{typeInfo.getType(), Object.class}).beanClass(ClassUtils.simpleClassForName(typeInfo.getType().getTypeName())).create((CreationalContext<T> e) -> this.createConverter((CreationalContext<Converter>)e));
    }

    protected Converter createConverter(CreationalContext<Converter> cc) {
        Class<?> converterClass = this.getBeanClass();
        Converter converter = null;
        try {
            converter = (Converter)converterClass.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(FacesConverterProducer.class.getName()).log(Level.SEVERE, "Could not instantiate converter " + converterClass.getName(), ex);
            throw new FacesException("Could not instantiate converter: " + converterClass.getName(), (Throwable)ex);
        }
        return converter;
    }
}

