/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.util.Arrays;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.ContextAwareTagMethodExpression;
import org.apache.myfaces.view.facelets.el.ContextAwareTagValueExpression;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.el.LocationMethodExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpression;
import org.apache.myfaces.view.facelets.el.ResourceELUtils;
import org.apache.myfaces.view.facelets.el.ResourceLocationValueExpression;
import org.apache.myfaces.view.facelets.el.TagMethodExpression;
import org.apache.myfaces.view.facelets.el.TagValueExpression;
import org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression;

public final class TagAttributeImpl
extends TagAttribute {
    private static final int EL_LITERAL = 1;
    private static final int EL_CC = 2;
    private static final int EL_CC_ATTR_ME = 4;
    private static final int EL_RESOURCE = 8;
    private final int capabilities;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;
    private volatile Object[] cachedExpression;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        boolean literal;
        this.location = location;
        this.namespace = ns;
        this.localName = localName == null ? qName : (localName.length() > 0 ? localName : qName);
        this.qName = qName;
        this.value = value;
        try {
            literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        boolean compositeComponentExpression = !literal ? CompositeComponentELUtils.isCompositeComponentExpression(this.value) : false;
        boolean compositeComponentAttrMethodExpression = compositeComponentExpression ? CompositeComponentELUtils.isCompositeComponentAttrsMethodExpression(this.value) : false;
        boolean resourceExpression = !literal ? ResourceELUtils.isResourceExpression(this.value) : false;
        this.capabilities = (literal ? 1 : 0) | (compositeComponentExpression ? 2 : 0) | (compositeComponentAttrMethodExpression ? 4 : 0) | (resourceExpression ? 8 : 0);
    }

    public boolean getBoolean(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    public int getInt(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Location getLocation() {
        return this.location;
    }

    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        Object[] localCachedExpression = this.cachedExpression;
        if (actx.isAllowCacheELExpressions() && localCachedExpression != null && localCachedExpression.length % 3 == 0) {
            for (int i = 0; i < localCachedExpression.length / 3; ++i) {
                if ((type != null || localCachedExpression[i * 3] != null) && (type == null || !type.equals(localCachedExpression[i * 3])) || !Arrays.equals(paramTypes, (Class[])localCachedExpression[i * 3 + 1])) continue;
                if ((this.capabilities & 2) != 0 && localCachedExpression[i * 3 + 2] instanceof LocationMethodExpression) {
                    Location location;
                    UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                        return ((LocationMethodExpression)localCachedExpression[i * 3 + 2]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel(), location);
                    }
                    return ((LocationMethodExpression)localCachedExpression[i * 3 + 2]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
                return (MethodExpression)localCachedExpression[i * 3 + 2];
            }
        }
        actx.beforeConstructELExpression();
        try {
            MethodExpression methodExpression = null;
            if ((this.capabilities & 4) != 0) {
                if (this.value.contains("(")) {
                    throw new ELException("Cannot add parameters to a MethodExpression pointing to cc.attrs");
                }
                ValueExpression valueExpr = this.getValueExpression(ctx, Object.class);
                methodExpression = new ValueExpressionMethodExpression(valueExpr);
                methodExpression = actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagMethodExpression(this, methodExpression) : new TagMethodExpression(this, methodExpression);
            } else {
                ExpressionFactory f = ctx.getExpressionFactory();
                methodExpression = f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes);
                methodExpression = actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagMethodExpression(this, methodExpression) : new TagMethodExpression(this, methodExpression);
                if ((this.capabilities & 2) != 0) {
                    Location ccLocation;
                    Location currentLocation = this.getLocation();
                    UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (ccLocation = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null && !ccLocation.getPath().equals(currentLocation.getPath())) {
                        currentLocation = ccLocation;
                    }
                    methodExpression = new LocationMethodExpression(currentLocation, methodExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
            }
            if (actx.isAllowCacheELExpressions() && !actx.isAnyFaceletsVariableResolved()) {
                if (localCachedExpression != null && localCachedExpression.length % 3 == 0) {
                    Object[] array = new Object[localCachedExpression.length + 3];
                    array[0] = type;
                    array[1] = paramTypes;
                    array[2] = methodExpression;
                    for (int i = 0; i < localCachedExpression.length; ++i) {
                        array[i + 3] = localCachedExpression[i];
                    }
                    this.cachedExpression = array;
                } else {
                    this.cachedExpression = new Object[]{type, paramTypes, methodExpression};
                }
            }
            MethodExpression methodExpression2 = methodExpression;
            return methodExpression2;
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        finally {
            actx.afterConstructELExpression();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    public String getQName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    public Object getObject(FaceletContext ctx, Class type) {
        if ((this.capabilities & 1) != 0) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        Object[] localCachedExpression = this.cachedExpression;
        if (actx.isAllowCacheELExpressions() && localCachedExpression != null && localCachedExpression.length == 2) {
            if (localCachedExpression[0] == null && type == null) {
                if ((this.capabilities & 2) != 0) {
                    Location location;
                    UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                        return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel(), location);
                    }
                    return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
                return (ValueExpression)localCachedExpression[1];
            }
            if (localCachedExpression[0] != null && localCachedExpression[0].equals(type)) {
                if ((this.capabilities & 2) != 0) {
                    Location location;
                    UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                        return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel(), location);
                    }
                    return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
                return (ValueExpression)localCachedExpression[1];
            }
        }
        actx.beforeConstructELExpression();
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            ValueExpression valueExpression = f.createValueExpression((ELContext)ctx, this.value, type);
            valueExpression = actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagValueExpression(this, valueExpression) : new TagValueExpression(this, valueExpression);
            if ((this.capabilities & 2) != 0) {
                Location ccLocation;
                Location currentLocation = this.getLocation();
                UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                if (cc != null && (ccLocation = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null && !ccLocation.getPath().equals(currentLocation.getPath())) {
                    currentLocation = ccLocation;
                }
                valueExpression = new LocationValueExpression(currentLocation, valueExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel());
            } else if ((this.capabilities & 8) != 0) {
                valueExpression = new ResourceLocationValueExpression(this.getLocation(), valueExpression);
            }
            if (actx.isAllowCacheELExpressions() && !actx.isAnyFaceletsVariableResolved()) {
                this.cachedExpression = new Object[]{type, valueExpression};
            }
            ValueExpression valueExpression2 = valueExpression;
            return valueExpression2;
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        finally {
            actx.afterConstructELExpression();
        }
    }

    public boolean isLiteral() {
        return (this.capabilities & 1) != 0;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }
}

