/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ClientConfig
implements Serializable {
    private static final long serialVersionUID = 581351549574404793L;
    public static final String COOKIE_NAME_NOSCRIPT_ENABLED = "mfNoScriptEnabled";
    private volatile Boolean javaScriptEnabled = null;
    protected String windowHandlerHtml;
    private volatile String userAgent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaScriptEnabled() {
        if (this.javaScriptEnabled == null) {
            ClientConfig clientConfig = this;
            synchronized (clientConfig) {
                if (this.javaScriptEnabled == null) {
                    Cookie cookie;
                    this.javaScriptEnabled = Boolean.TRUE;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext != null && (cookie = (Cookie)facesContext.getExternalContext().getRequestCookieMap().get(COOKIE_NAME_NOSCRIPT_ENABLED)) != null) {
                        this.javaScriptEnabled = Boolean.parseBoolean(cookie.getValue());
                    }
                }
            }
        }
        return this.javaScriptEnabled;
    }

    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        Object r;
        this.javaScriptEnabled = javaScriptEnabled;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (r = facesContext.getExternalContext().getResponse()) instanceof HttpServletResponse) {
            Cookie cookie = new Cookie(COOKIE_NAME_NOSCRIPT_ENABLED, "" + javaScriptEnabled);
            cookie.setPath("/");
            HttpServletResponse response = (HttpServletResponse)r;
            response.addCookie(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(FacesContext facesContext) {
        if (this.userAgent == null) {
            ClientConfig clientConfig = this;
            synchronized (clientConfig) {
                Map<String, String[]> requestHeaders;
                if (this.userAgent == null && (requestHeaders = facesContext.getExternalContext().getRequestHeaderValuesMap()) != null && requestHeaders.containsKey("User-Agent")) {
                    String[] userAgents = requestHeaders.get("User-Agent");
                    this.userAgent = userAgents.length > 0 ? userAgents[0] : null;
                }
            }
        }
        return this.userAgent;
    }

    public boolean isClientSideWindowHandlerRequest(FacesContext facesContext) {
        if (!this.isJavaScriptEnabled()) {
            return false;
        }
        String userAgent = this.getUserAgent(facesContext);
        return userAgent == null || userAgent.indexOf("bot") < 0 && userAgent.indexOf("Bot") < 0 && userAgent.indexOf("Slurp") < 0 && userAgent.indexOf("Crawler") < 0;
    }
}

