/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.apache.myfaces.core.api.shared.ExternalSpecifications;
import org.apache.myfaces.core.api.shared.FacesMessageInterpolator;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.ValueReferenceResolver;
import org.apache.myfaces.core.api.shared.lang.ClassUtils;

public class BeanValidator
implements Validator,
PartialStateHolder {
    private static final Logger log = Logger.getLogger(BeanValidator.class.getName());
    public static final String VALIDATOR_ID = "javax.faces.Bean";
    public static final String MESSAGE_ID = "javax.faces.validator.BeanValidator.MESSAGE";
    public static final String DISABLE_DEFAULT_BEAN_VALIDATOR_PARAM_NAME = "javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR";
    public static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";
    public static final String VALIDATION_GROUPS_DELIMITER = ",";
    public static final String EMPTY_VALIDATION_GROUPS_PATTERN = "^[\\W,]*$";
    public static final String ENABLE_VALIDATE_WHOLE_BEAN_PARAM_NAME = "javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN";
    private static final Class<?>[] DEFAULT_VALIDATION_GROUPS_ARRAY = new Class[]{Default.class};
    private static final String DEFAULT_VALIDATION_GROUP_NAME = "javax.validation.groups.Default";
    private static final String CANDIDATE_COMPONENT_VALUES_MAP = "oam.WBV.candidatesMap";
    private static final String BEAN_VALIDATION_FAILED = "oam.WBV.validationFailed";
    private String validationGroups;
    private Class<?>[] validationGroupsArray;
    private boolean isTransient = false;
    private boolean _initialStateMarked = false;

    public void validate(FacesContext context, UIComponent component, Object value) {
        Set constraintViolations;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            if (context.isProjectStage(ProjectStage.Development)) {
                log.fine("cannot validate component with empty value: " + component.getClientId(context));
            }
            return;
        }
        ValueReference reference = ValueReferenceResolver.resolve(valueExpression, context);
        if (reference == null) {
            return;
        }
        Object base = reference.getBase();
        if (base == null) {
            return;
        }
        Class<?> valueBaseClass = base.getClass();
        if (valueBaseClass == null) {
            return;
        }
        Object referenceProperty = reference.getProperty();
        if (!(referenceProperty instanceof String)) {
            return;
        }
        String valueProperty = (String)referenceProperty;
        ValidatorFactory validatorFactory = this.createValidatorFactory(context);
        javax.validation.Validator validator = this.createValidator(validatorFactory, context);
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(valueBaseClass);
        if (!beanDescriptor.isBeanConstrained()) {
            return;
        }
        Class[] validationGroupsArray = this.validationGroupsArray;
        boolean containsOtherValidationGroup = false;
        if (validationGroupsArray != null && validationGroupsArray.length > 0) {
            for (Class clazz : validationGroupsArray) {
                if (Default.class.equals((Object)clazz)) continue;
                containsOtherValidationGroup = true;
                break;
            }
        }
        if (!(constraintViolations = validator.validateValue(valueBaseClass, valueProperty, value, validationGroupsArray)).isEmpty()) {
            LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(constraintViolations.size());
            for (Object violation : constraintViolations) {
                ConstraintViolation constraintViolation = (ConstraintViolation)violation;
                String message = constraintViolation.getMessage();
                Object[] args = new Object[]{message, MessageUtils.getLabel(context, component)};
                FacesMessage msg = MessageUtils.getErrorMessage(context, MESSAGE_ID, args);
                messages.add(msg);
            }
            if (this.isValidateWholeBeanEnabled(context) && containsOtherValidationGroup) {
                context.getViewRoot().getTransientStateHelper().putTransient(BEAN_VALIDATION_FAILED, Boolean.TRUE);
            }
            throw new ValidatorException(messages);
        }
        if (this.isValidateWholeBeanEnabled(context) && containsOtherValidationGroup) {
            LinkedHashMap<String, Object> candidatesMap = (LinkedHashMap<String, Object>)context.getViewRoot().getTransientStateHelper().getTransient(CANDIDATE_COMPONENT_VALUES_MAP);
            if (candidatesMap == null) {
                candidatesMap = new LinkedHashMap<String, Object>();
                context.getViewRoot().getTransientStateHelper().putTransient(CANDIDATE_COMPONENT_VALUES_MAP, candidatesMap);
            }
            candidatesMap.put(component.getClientId(context), value);
        }
    }

    private boolean isValidateWholeBeanEnabled(FacesContext facesContext) {
        Boolean value = (Boolean)facesContext.getAttributes().get(ENABLE_VALIDATE_WHOLE_BEAN_PARAM_NAME);
        if (value == null) {
            String enabled = facesContext.getExternalContext().getInitParameter(ENABLE_VALIDATE_WHOLE_BEAN_PARAM_NAME);
            value = enabled == null ? Boolean.FALSE : Boolean.valueOf(enabled);
        }
        return Boolean.TRUE.equals(value);
    }

    private javax.validation.Validator createValidator(ValidatorFactory validatorFactory, FacesContext context) {
        if (this.validationGroupsArray == null) {
            this.postSetValidationGroups();
        }
        return validatorFactory.usingContext().messageInterpolator((MessageInterpolator)new FacesMessageInterpolator(validatorFactory.getMessageInterpolator(), context)).getValidator();
    }

    private ValidatorFactory createValidatorFactory(FacesContext context) {
        Map<String, Object> applicationMap = context.getExternalContext().getApplicationMap();
        Object attr = applicationMap.get(VALIDATOR_FACTORY_KEY);
        if (attr instanceof ValidatorFactory) {
            return (ValidatorFactory)attr;
        }
        BeanValidator beanValidator = this;
        synchronized (beanValidator) {
            if (ExternalSpecifications.isBeanValidationAvailable()) {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                applicationMap.put(VALIDATOR_FACTORY_KEY, factory);
                return factory;
            }
            throw new FacesException("Bean Validation is not present");
        }
    }

    private void postSetValidationGroups() {
        if (this.validationGroups == null || this.validationGroups.matches(EMPTY_VALIDATION_GROUPS_PATTERN)) {
            this.validationGroupsArray = DEFAULT_VALIDATION_GROUPS_ARRAY;
        } else {
            String[] classes = this.validationGroups.split(VALIDATION_GROUPS_DELIMITER);
            ArrayList validationGroupsList = new ArrayList(classes.length);
            for (String clazz : classes) {
                if ((clazz = clazz.trim()).isEmpty()) continue;
                try {
                    Class theClass = ClassUtils.classForName(clazz);
                    validationGroupsList.add(theClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load validation group", e);
                }
            }
            this.validationGroupsArray = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.initialStateMarked()) {
            return this.validationGroups;
        }
        if (DEFAULT_VALIDATION_GROUP_NAME.equals(this.validationGroups)) {
            return null;
        }
        return this.validationGroups;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.validationGroups = state != null ? (String)state : null;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    public void setValidationGroups(String validationGroups) {
        this.validationGroups = validationGroups;
        this.clearInitialState();
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

