/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.resolver;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;

public final class CompositeComponentELResolver
extends ELResolver {
    private static final String ATTRIBUTES_MAP = "attrs";
    private static final String PARENT_COMPOSITE_COMPONENT = "parent";
    private static final String COMPOSITE_COMPONENT_ATTRIBUTES_MAPS = "org.apache.myfaces.COMPOSITE_COMPONENT_ATTRIBUTES_MAPS";
    private MyfacesConfig myfacesConfig;

    public CompositeComponentELResolver(MyfacesConfig myfacesConfig) {
        this.myfacesConfig = myfacesConfig;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base != null && property != null && base instanceof CompositeComponentAttributesMapWrapper && property instanceof String) {
            FacesContext facesContext = CompositeComponentELResolver.facesContext(context);
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            if (facesContext == null) {
                return null;
            }
            if (!this.myfacesConfig.isStrictJsf2CCELResolver()) {
                Class exprType = null;
                Class<?> metaType = null;
                CompositeComponentAttributesMapWrapper evalMap = (CompositeComponentAttributesMapWrapper)base;
                ValueExpression ve = evalMap.getExpression((String)property);
                if (ve != null) {
                    exprType = ve.getType(context);
                }
                if (StringUtils.isNotBlank((String)property) && evalMap.propertyDescriptors != null) {
                    for (PropertyDescriptor pd : evalMap.propertyDescriptors) {
                        if (!property.equals(pd.getName())) continue;
                        metaType = CompositeComponentELResolver.resolveType(context, pd);
                        break;
                    }
                }
                if (metaType != null && (exprType == null || exprType.isAssignableFrom(metaType))) {
                    context.setPropertyResolved(true);
                    return metaType;
                }
                return exprType;
            }
        }
        return null;
    }

    private static Class<?> resolveType(ELContext context, PropertyDescriptor pd) {
        if (pd != null) {
            Object type = pd.getValue("type");
            if (type != null) {
                if ((type = ((ValueExpression)type).getValue(context)) instanceof String) {
                    try {
                        type = ClassUtils.javaDefaultTypeToClass((String)type);
                    }
                    catch (ClassNotFoundException e) {
                        type = null;
                    }
                }
                return (Class)type;
            }
            return pd.getPropertyType();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null && base instanceof UIComponent && property != null && UIComponent.isCompositeComponent((UIComponent)base)) {
            String propName = property.toString();
            UIComponent baseComponent = (UIComponent)base;
            if (propName.equals(ATTRIBUTES_MAP)) {
                context.setPropertyResolved(true);
                return this._getCompositeComponentAttributesMapWrapper(baseComponent, context);
            }
            if (propName.equals(PARENT_COMPOSITE_COMPONENT)) {
                context.setPropertyResolved(true);
                return UIComponent.getCompositeComponentParent(baseComponent);
            }
        }
        return null;
    }

    private Map<String, Object> _getCompositeComponentAttributesMapWrapper(UIComponent baseComponent, ELContext elContext) {
        Map<Object, Object> contextMap = CompositeComponentELResolver.facesContext(elContext).getAttributes();
        WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>> compositeComponentAttributesMaps = (WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>>)contextMap.get(COMPOSITE_COMPONENT_ATTRIBUTES_MAPS);
        Map<String, Object> attributesMap = null;
        if (compositeComponentAttributesMaps != null) {
            WeakReference weakReference = (WeakReference)compositeComponentAttributesMaps.get(baseComponent);
            if (weakReference != null) {
                attributesMap = (Map)weakReference.get();
            }
            if (attributesMap == null) {
                attributesMap = new CompositeComponentAttributesMapWrapper(baseComponent);
                compositeComponentAttributesMaps.put(baseComponent, new WeakReference<CompositeComponentAttributesMapWrapper>((CompositeComponentAttributesMapWrapper)attributesMap));
            }
        } else {
            attributesMap = new CompositeComponentAttributesMapWrapper(baseComponent);
            compositeComponentAttributesMaps = new WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>>();
            compositeComponentAttributesMaps.put(baseComponent, new WeakReference<CompositeComponentAttributesMapWrapper>((CompositeComponentAttributesMapWrapper)attributesMap));
            contextMap.put(COMPOSITE_COMPONENT_ATTRIBUTES_MAPS, compositeComponentAttributesMaps);
        }
        return attributesMap;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    private final class CompositeComponentAttributesMapWrapper
    implements CompositeComponentExpressionHolder,
    Map<String, Object> {
        private final UIComponent component;
        private final BeanInfo beanInfo;
        private final Map<String, Object> originalMap;
        private final PropertyDescriptor[] propertyDescriptors;
        private final CompositeComponentBeanInfo ccBeanInfo;

        private CompositeComponentAttributesMapWrapper(UIComponent component) {
            this.component = component;
            this.originalMap = component.getAttributes();
            this.beanInfo = (BeanInfo)this.originalMap.get("javax.faces.component.BEANINFO_KEY");
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
            this.ccBeanInfo = this.beanInfo instanceof CompositeComponentBeanInfo ? (CompositeComponentBeanInfo)this.beanInfo : null;
        }

        @Override
        public ValueExpression getExpression(String name) {
            ValueExpression ve = this.component.getValueExpression(name);
            return ve;
        }

        @Override
        public void clear() {
            this.originalMap.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            boolean value = this.originalMap.containsKey(key);
            if (value) {
                return value;
            }
            if (this.ccBeanInfo != null) {
                PropertyDescriptor attribute = this.ccBeanInfo.getPropertyDescriptorsMap().get((String)key);
                if (attribute != null) {
                    return attribute.getValue("default") != null;
                }
            } else {
                for (PropertyDescriptor attribute : this.propertyDescriptors) {
                    if (!attribute.getName().equals(key)) continue;
                    return attribute.getValue("default") != null;
                }
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.originalMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.originalMap.entrySet();
        }

        @Override
        public Object get(Object key) {
            Object obj;
            block4: {
                block3: {
                    obj = this.originalMap.get(key);
                    if (obj != null) {
                        return obj;
                    }
                    if (this.ccBeanInfo == null) break block3;
                    PropertyDescriptor attribute = this.ccBeanInfo.getPropertyDescriptorsMap().get(key);
                    if (attribute == null) break block4;
                    obj = attribute.getValue("default");
                    break block4;
                }
                for (PropertyDescriptor attribute : this.propertyDescriptors) {
                    if (!attribute.getName().equals(key)) continue;
                    obj = attribute.getValue("default");
                    break;
                }
            }
            if (obj != null && obj instanceof ValueExpression) {
                return ((ValueExpression)obj).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            return obj;
        }

        @Override
        public boolean isEmpty() {
            return this.originalMap.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.originalMap.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            ValueExpression valueExpression = this.component.getValueExpression(key);
            if (valueExpression != null) {
                valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), value);
                return null;
            }
            return this.originalMap.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            return this.originalMap.remove(key);
        }

        @Override
        public int size() {
            return this.originalMap.size();
        }

        @Override
        public Collection<Object> values() {
            return this.originalMap.values();
        }
    }
}

