/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;

public class CDIUtils {
    public static BeanManager getBeanManager(ExternalContext externalContext) {
        return (BeanManager)externalContext.getApplicationMap().get("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static <T> T lookup(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        return CDIUtils.resolveInstance(bm, beans, clazz);
    }

    public static Object lookup(BeanManager bm, String name) {
        Set beans = bm.getBeans(name);
        return CDIUtils.resolveInstance(bm, beans, Object.class);
    }

    private static <T> T resolveInstance(BeanManager bm, Set<Bean<?>> beans, Type type) {
        Bean bean = bm.resolve(beans);
        CreationalContext cc = bm.createCreationalContext((Contextual)bean);
        Object dao = bm.getReference(bean, type, cc);
        return (T)dao;
    }

    public static boolean isSessionScopeActive(BeanManager beanManager) {
        try {
            Context ctx = beanManager.getContext(SessionScoped.class);
            return ctx != null;
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

