/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component._ValidationUtils;
import javax.faces.context.ExternalContext;

final class _ExternalSpecifications {
    private static final Logger log = Logger.getLogger(_ExternalSpecifications.class.getName());
    private static volatile Boolean beanValidationAvailable;
    private static volatile Boolean cdiAvailable;

    public static boolean isBeanValidationAvailable() {
        if (beanValidationAvailable == null) {
            try {
                try {
                    beanValidationAvailable = Class.forName("javax.validation.Validation") != null;
                }
                catch (ClassNotFoundException e) {
                    beanValidationAvailable = Boolean.FALSE;
                }
                if (beanValidationAvailable.booleanValue()) {
                    try {
                        _ValidationUtils.tryBuildDefaultValidatorFactory();
                    }
                    catch (Throwable t) {
                        log.log(Level.FINE, "Error initializing Bean Validation (could be normal)", t);
                        beanValidationAvailable = false;
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Error loading class (could be normal)", t);
                beanValidationAvailable = false;
            }
            log.info("MyFaces Bean Validation support " + (beanValidationAvailable != false ? "enabled" : "disabled"));
        }
        return beanValidationAvailable;
    }

    public static boolean isCDIAvailable(ExternalContext externalContext) {
        if (cdiAvailable == null) {
            try {
                cdiAvailable = Class.forName("javax.enterprise.inject.spi.BeanManager") != null;
            }
            catch (Throwable t) {
                cdiAvailable = false;
            }
            if (cdiAvailable.booleanValue()) {
                cdiAvailable = externalContext.getApplicationMap().containsKey("oam.cdi.BEAN_MANAGER_INSTANCE");
            }
            log.info("MyFaces CDI support " + (cdiAvailable != false ? "enabled" : "disabled"));
            return cdiAvailable;
        }
        if (Boolean.TRUE.equals(cdiAvailable)) {
            return externalContext.getApplicationMap().containsKey("oam.cdi.BEAN_MANAGER_INSTANCE");
        }
        return cdiAvailable;
    }

    private _ExternalSpecifications() {
    }
}

