/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public final class ClassLoaderUtils {
    private static final Logger _LOG = Logger.getLogger(ClassLoaderUtils.class.getName());

    private ClassLoaderUtils() {
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(name, null);
    }

    public static URL getResource(String name) {
        return ClassLoaderUtils.getResource(name, null);
    }

    public static InputStream getResourceAsStream(String name) {
        return ClassLoaderUtils.getResourceAsStream(name, null);
    }

    public static Class<?> loadClass(String name, ClassLoader callerClassLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader loader = ClassLoaderUtils.getContextClassLoader();
            if (loader != null) {
                clazz = loader.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = callerClassLoader != null ? callerClassLoader.loadClass(name) : Class.forName(name);
        }
        return clazz;
    }

    public static URL getResource(String name, ClassLoader callerClassLoader) {
        ClassLoaderUtils._checkResourceName(name);
        URL url = null;
        ClassLoader loader = ClassLoaderUtils.getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(name);
        }
        if (url == null) {
            url = callerClassLoader != null ? callerClassLoader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String name, ClassLoader callerClassLoader) {
        ClassLoaderUtils._checkResourceName(name);
        InputStream stream = null;
        ClassLoader loader = ClassLoaderUtils.getContextClassLoader();
        if (loader != null) {
            stream = loader.getResourceAsStream(name);
        }
        if (stream == null) {
            stream = callerClassLoader != null ? callerClassLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        return stream;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws PrivilegedActionException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                return cl;
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException(pae);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getServices(String service) {
        block12: {
            String serviceUri = "META-INF/services/" + service;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Enumeration<URL> urls = loader.getResources(serviceUri);
                if (!urls.hasMoreElements()) break block12;
                ArrayList<Object> services = new ArrayList<Object>(1);
                HashSet<String> keys = new HashSet<String>(20);
                block7: do {
                    URL url = urls.nextElement();
                    if (_LOG.isLoggable(Level.FINEST)) {
                        _LOG.finest("Processing: " + url);
                    }
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        try {
                            while (true) {
                                String line;
                                if ((line = in.readLine()) == null) {
                                    continue block7;
                                }
                                String className = ClassLoaderUtils._parseLine(line);
                                if (className == null || !keys.add(className)) continue;
                                Object instance = ClassLoaderUtils._getClass(loader, className);
                                services.add(instance);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        if (!_LOG.isLoggable(Level.WARNING)) continue;
                        _LOG.log(Level.WARNING, "Error parsing URL: " + url, e);
                    }
                } while (urls.hasMoreElements());
                if (services.size() == 1) {
                    return Collections.singletonList(services.get(0));
                }
                return Collections.unmodifiableList(services);
            }
            catch (IOException e) {
                if (!_LOG.isLoggable(Level.SEVERE)) break block12;
                _LOG.log(Level.SEVERE, "Error loading Resource: " + serviceUri, e);
            }
        }
        return Collections.emptyList();
    }

    private static String _parseLine(String line) {
        int hashIndex = line.indexOf(35);
        if (hashIndex >= 0) {
            line = line.substring(0, hashIndex);
        }
        if ((line = line.trim()).length() > 0) {
            return line;
        }
        return null;
    }

    private static Object _getClass(ClassLoader loader, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = loader.loadClass(className);
        return clazz.newInstance();
    }

    private static void _checkResourceName(String name) {
        if (name != null && name.startsWith("/") && _LOG.isLoggable(Level.WARNING)) {
            _LOG.log(Level.WARNING, "Resource name not portable: " + name);
        }
    }
}

