/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagDecorator;
import org.apache.myfaces.view.facelets.compiler.TagLibraryConfig;
import org.apache.myfaces.view.facelets.tag.CompositeTagDecorator;
import org.apache.myfaces.view.facelets.tag.CompositeTagLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.util.ParameterCheck;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;

public abstract class Compiler {
    protected static final Logger log = Logger.getLogger(Compiler.class.getName());
    public static final String EXPRESSION_FACTORY = "compiler.ExpressionFactory";
    private static final TagLibrary EMPTY_LIBRARY = new CompositeTagLibrary(new TagLibrary[0]);
    private static final TagDecorator EMPTY_DECORATOR = new CompositeTagDecorator(new TagDecorator[0]);
    private boolean validating = false;
    private boolean trimmingWhitespace = false;
    private boolean trimmingComments = false;
    private final List<TagLibrary> libraries = new ArrayList<TagLibrary>();
    private final List<TagDecorator> decorators = new ArrayList<TagDecorator>();
    private final Map<String, String> features = new HashMap<String, String>();
    private boolean initialized = false;
    private boolean developmentProjectStage = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        log.fine("Initializing");
        try {
            TagLibraryConfig cfg = new TagLibraryConfig();
            cfg.loadImplicit(FacesContext.getCurrentInstance(), this);
            if (!this.createTagLibrary().containsNamespace("http://java.sun.com/jsf/facelets")) {
                log.severe("Missing Built-in Tag Libraries! Make sure they are included within the META-INF directory of Facelets' Jar");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Compiler Initialization Error", e);
        }
        finally {
            this.initialized = true;
        }
        log.fine("Initialization Successful");
    }

    public final FaceletHandler compile(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.doCompile(src, alias);
    }

    public final FaceletHandler compileViewMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.doCompileViewMetadata(src, alias);
    }

    public final FaceletHandler compileCompositeComponentMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.doCompileCompositeComponentMetadata(src, alias);
    }

    protected abstract FaceletHandler doCompile(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    protected abstract FaceletHandler doCompileViewMetadata(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    protected abstract FaceletHandler doCompileCompositeComponentMetadata(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    public final TagDecorator createTagDecorator() {
        if (this.decorators.size() > 0) {
            return new CompositeTagDecorator(this.decorators.toArray(new TagDecorator[this.decorators.size()]));
        }
        return EMPTY_DECORATOR;
    }

    public final void addTagDecorator(TagDecorator decorator) {
        ParameterCheck.notNull("decorator", decorator);
        if (!this.decorators.contains(decorator)) {
            this.decorators.add(decorator);
        }
    }

    public final ExpressionFactory createExpressionFactory() {
        ExpressionFactory el = null;
        el = (ExpressionFactory)this.featureInstance(EXPRESSION_FACTORY);
        if (el == null) {
            try {
                el = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
                if (el == null) {
                    log.warning("No default ExpressionFactory from Faces Implementation, attempting to load from Feature[compiler.ExpressionFactory]");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return el;
    }

    private final Object featureInstance(String name) {
        String type = this.features.get(name);
        if (type != null) {
            try {
                return ReflectionUtil.forName(type).newInstance();
            }
            catch (Throwable t) {
                throw new FaceletException("Could not instantiate feature[" + name + "]: " + type);
            }
        }
        return null;
    }

    public final TagLibrary createTagLibrary() {
        if (this.libraries.size() > 0) {
            return new CompositeTagLibrary(this.libraries.toArray(new TagLibrary[this.libraries.size()]));
        }
        return EMPTY_LIBRARY;
    }

    public final void addTagLibrary(TagLibrary library) {
        ParameterCheck.notNull("library", library);
        if (!this.libraries.contains(library)) {
            this.libraries.add(library);
        }
    }

    public final void setFeature(String name, String value) {
        this.features.put(name, value);
    }

    public final String getFeature(String name) {
        return this.features.get(name);
    }

    public final boolean isTrimmingComments() {
        return this.trimmingComments;
    }

    public final void setTrimmingComments(boolean trimmingComments) {
        this.trimmingComments = trimmingComments;
    }

    public final boolean isTrimmingWhitespace() {
        return this.trimmingWhitespace;
    }

    public final void setTrimmingWhitespace(boolean trimmingWhitespace) {
        this.trimmingWhitespace = trimmingWhitespace;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final void setValidating(boolean validating) {
        this.validating = validating;
    }

    public final boolean isDevelopmentProjectStage() {
        return this.developmentProjectStage;
    }

    public final void setDevelopmentProjectStage(boolean developmentProjectStage) {
        this.developmentProjectStage = developmentProjectStage;
    }
}

