/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlResponseWriterImpl;

public class HtmlRenderKitImpl
extends RenderKit {
    private static final Log log = LogFactory.getLog(HtmlRenderKitImpl.class);
    private Map<String, Map<String, Renderer>> _renderers = new ConcurrentHashMap<String, Map<String, Renderer>>(64, 0.75f, 1);
    private ResponseStateManager _responseStateManager = new HtmlResponseStateManager();

    public Renderer getRenderer(String componentFamily, String rendererType) {
        if (componentFamily == null) {
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            throw new NullPointerException("renderer type must not be null.");
        }
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        Renderer renderer = null;
        if (familyRendererMap != null) {
            renderer = familyRendererMap.get(rendererType);
        }
        if (renderer == null) {
            log.warn((Object)("Unsupported component-family/renderer-type: " + componentFamily + "/" + rendererType));
        }
        return renderer;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        if (componentFamily == null) {
            log.error((Object)"addRenderer: componentFamily = null is not allowed");
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            log.error((Object)"addRenderer: rendererType = null is not allowed");
            throw new NullPointerException("renderer type must not be null.");
        }
        if (renderer == null) {
            log.error((Object)"addRenderer: renderer = null is not allowed");
            throw new NullPointerException("renderer must not be null.");
        }
        this._put(componentFamily, rendererType, renderer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("add Renderer family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName()));
        }
    }

    private synchronized void _put(String componentFamily, String rendererType, Renderer renderer) {
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        if (familyRendererMap == null) {
            familyRendererMap = new ConcurrentHashMap<String, Renderer>(8, 0.75f, 1);
            this._renderers.put(componentFamily, familyRendererMap);
        } else if (familyRendererMap.get(rendererType) != null) {
            log.debug((Object)("Overwriting renderer with family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName()));
        }
        familyRendererMap.put(rendererType, renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeListString, String characterEncoding) {
        String selectedContentType = HtmlRendererUtils.selectContentType(contentTypeListString);
        if (characterEncoding == null) {
            characterEncoding = HtmlRendererUtils.DEFAULT_CHAR_ENCODING;
        }
        return new HtmlResponseWriterImpl(writer, selectedContentType, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return new MyFacesResponseStream(outputStream);
    }

    private static class MyFacesResponseStream
    extends ResponseStream {
        private OutputStream output;

        public MyFacesResponseStream(OutputStream output) {
            this.output = output;
        }

        public void write(int b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
        }

        public void flush() throws IOException {
            this.output.flush();
        }

        public void close() throws IOException {
            this.output.close();
        }
    }
}

