/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotWritableException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyResolverToELResolver
extends ELResolver {
    private PropertyResolver propertyResolver;
    private ExpressionFactory expressionFactory;

    public PropertyResolverToELResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, javax.el.PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base == null || property == null) {
            return;
        }
        try {
            context.setPropertyResolved(true);
            if (PropertyResolverToELResolver.needsCoersion(base)) {
                this.propertyResolver.setValue(base, this.coerceToInt(property), value);
            } else {
                this.propertyResolver.setValue(base, property, value);
            }
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
        }
        catch (PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (base == null || property == null) {
            return true;
        }
        try {
            context.setPropertyResolved(true);
            boolean result = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.isReadOnly(base, this.coerceToInt(property)) : this.propertyResolver.isReadOnly(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return result;
        }
        catch (PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            Object value = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.getValue(base, this.coerceToInt(property)) : this.propertyResolver.getValue(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return value;
        }
        catch (PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            Class value = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.getType(base, this.coerceToInt(property)) : this.propertyResolver.getType(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return value;
        }
        catch (PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static boolean needsCoersion(Object base) {
        return base instanceof List || base.getClass().isArray();
    }

    protected ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.expressionFactory = appFactory.getApplication().getExpressionFactory();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    private int coerceToInt(Object property) {
        return (Integer)this.getExpressionFactory().coerceToType(property, Integer.class);
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

