/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class LPR {
    public static final int UNKNOWN = 0;
    private String host;
    private int port = 515;
    private String user = System.getProperty("user.name");
    private Vector jobs = new Vector();
    private String hostname = null;
    private String jobname = "";
    private String cfAlen;
    private String cfA;
    private int copies = 1;
    private int timeout = 60000;
    private boolean cfA_formatted = false;
    private boolean cfA_postscript = false;
    private boolean cfA_banner = false;
    private boolean cfA_pr = false;

    public LPR() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e2) {
            System.out.println("can't resolve hostname");
            this.hostname = null;
        }
    }

    public LPR(String host, String user) {
        this();
        this.setHost(host);
        this.setUser(user);
    }

    public LPR(String host, int port, String user) {
        this();
        this.setHost(host);
        this.setUser(user);
        this.setPort(port);
    }

    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getCfA_postscript() {
        return this.cfA_postscript;
    }

    public void setCfA_postscript(boolean value) {
        this.cfA_postscript = value;
        if (value) {
            this.cfA_formatted = false;
        }
    }

    public String getCfA_jobname() {
        return this.jobname;
    }

    public void setCfA_jobname(String value) {
        this.jobname = value;
        this.cfA_banner = true;
    }

    public boolean getCfA_pr() {
        return this.cfA_pr;
    }

    public void setCfA_pr(boolean value) {
        this.cfA_pr = value;
    }

    public boolean getCfA_banner() {
        return this.cfA_banner;
    }

    public void setCfA_banner(boolean value) {
        this.cfA_banner = value;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String value) {
        this.hostname = value;
    }

    public void setCopies(int value) {
        this.copies = value;
    }

    public int getCopies() {
        return this.copies;
    }

    public boolean printWaitingJobs(String queue) {
        Socket printer = this.connect();
        if (printer != null) {
            DataOutputStream out;
            BufferedReader in;
            block4: {
                in = new BufferedReader(new InputStreamReader(printer.getInputStream()));
                out = new DataOutputStream(printer.getOutputStream());
                out.write(1);
                out.writeBytes(String.valueOf(queue) + "\n");
                if (in.read() == 0) break block4;
                System.err.println("Error while start print jobs on queue " + queue);
                return false;
            }
            try {
                this.close(printer, in, out);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean removeJob(String queue, String user, String jobid) {
        Socket printer = this.connect();
        if (printer != null) {
            DataOutputStream out;
            BufferedReader in;
            block4: {
                in = new BufferedReader(new InputStreamReader(printer.getInputStream()));
                out = new DataOutputStream(printer.getOutputStream());
                out.write(5);
                out.writeBytes(String.valueOf(queue) + " " + user + " " + jobid + "\n");
                if (in.read() == 0) break block4;
                System.err.println("Error while remove print job " + jobid + " on queue " + queue);
                return false;
            }
            try {
                this.close(printer, in, out);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getQueueState(String queue, boolean shortstate) {
        Socket printer = this.connect();
        if (printer != null) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(printer.getInputStream()));
                DataOutputStream out = new DataOutputStream(printer.getOutputStream());
                if (shortstate) {
                    out.write(3);
                } else {
                    out.write(4);
                }
                out.writeBytes(String.valueOf(queue) + " \n");
                new LineNumberReader(in);
                String line = in.readLine();
                this.close(printer, in, out);
                return line;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String print(String queue, byte[] dfA, String document) {
        PrintJob job = new PrintJob(queue, dfA, document);
        job.start();
        return job.getJobId();
    }

    public String print(String queue, String dfA, String document) {
        PrintJob job = new PrintJob(queue, dfA.toCharArray(), document);
        job.start();
        return job.getJobId();
    }

    public String print(String queue, char[] dfA, String document) {
        PrintJob job = new PrintJob(queue, dfA, document);
        job.start();
        return job.getJobId();
    }

    public String print(String queue, File file, String document) {
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                int count = 0;
                int size = (int)file.length();
                while (count < size) {
                    count += in.read(data, count, size - count);
                }
                in.close();
                PrintJob job = new PrintJob(queue, data, document);
                job.start();
                this.waitFor(job.getJobId());
                return job.getJobId();
            }
            catch (Exception e) {
                System.out.println("error while printig file " + file.getName() + "\n" + e.getMessage());
            }
        } else {
            System.out.println("file " + file.getName() + " not found");
        }
        return null;
    }

    public void waitFor(String jobid) {
        try {
            while (this.jobs.contains(jobid)) {
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean print(String queue, String document, byte[] dfA1, char[] dfA2, int mode, String jobid) {
        Socket printer = this.connect();
        if (printer != null) {
            boolean rc = true;
            this.makecfA(document, jobid);
            String dfAlen = String.valueOf(mode == 1 ? dfA1.length : dfA2.length);
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(printer.getInputStream()));
                DataOutputStream out = new DataOutputStream(printer.getOutputStream());
                System.out.println("jobid: " + jobid + " queue: " + queue);
                out.write(2);
                out.writeBytes(String.valueOf(queue) + "\n");
                out.flush();
                if (in.read() != 0) {
                    rc = false;
                    System.out.println("Error while start printing on queue " + queue);
                }
                out.write(2);
                out.writeBytes(this.cfAlen);
                out.writeBytes(" ");
                out.writeBytes("cfA" + jobid + this.user + "\n");
                out.flush();
                if (in.read() != 0) {
                    rc = false;
                    System.out.println("Error while start sending control file");
                }
                out.writeBytes(this.cfA);
                out.writeByte(0);
                out.flush();
                if (in.read() != 0) {
                    rc = false;
                    System.out.println("Error while sending control file");
                }
                out.write(3);
                out.writeBytes(dfAlen);
                out.writeBytes(" ");
                out.writeBytes("dfA" + jobid + this.user + "\n");
                out.flush();
                if (in.read() != 0) {
                    rc = false;
                    System.err.println("Error while start sending data file");
                }
                if (mode == 1) {
                    out.write(dfA1);
                } else {
                    out.writeBytes(new String(dfA2));
                }
                out.writeByte(0);
                out.flush();
                if (in.read() != 0) {
                    rc = false;
                    System.out.println("Error while sending data file");
                }
                out.flush();
                this.close(printer, in, out);
            }
            catch (Exception e) {
                rc = false;
                e.printStackTrace();
            }
            return rc;
        }
        return false;
    }

    private Socket connect() {
        try {
            System.out.println("Connect with " + this.host);
            Socket socket = new Socket(InetAddress.getByName(this.host), this.port);
            socket.setSoTimeout(this.timeout);
            return socket;
        }
        catch (Exception e1) {
            System.out.println("Error while connecting to " + this.host + ":" + this.port);
            System.out.println(e1.getMessage());
            return null;
        }
    }

    private void close(Socket socket, BufferedReader in, DataOutputStream out) {
        try {
            in.close();
            out.close();
            socket.close();
        }
        catch (Exception e) {
            System.out.println("Errror while closing printerport");
            System.out.println(e.getMessage());
        }
    }

    private void makecfA(String document, String jobid) {
        this.cfA = "";
        if (this.hostname != null) {
            this.cfA = String.valueOf(this.cfA) + "H" + this.hostname + "\n";
        }
        this.cfA = String.valueOf(this.cfA) + "P" + this.user + "\n";
        this.cfA = String.valueOf(this.cfA) + "J" + document + "\n";
        this.cfA = String.valueOf(this.cfA) + "L" + this.user + "\n";
        if (this.cfA_formatted) {
            this.cfA = String.valueOf(this.cfA) + "f" + document + "\n";
        }
        if (this.cfA_postscript) {
            this.cfA = String.valueOf(this.cfA) + "o" + document + "\n";
        }
        if (this.cfA_banner) {
            this.cfA = String.valueOf(this.cfA) + "L" + this.jobname + "\n";
        }
        this.cfA = String.valueOf(this.cfA) + "UdfA" + jobid + this.hostname + "\n";
        int i = 0;
        while (i < this.copies) {
            this.cfA = String.valueOf(this.cfA) + "ldfA" + jobid + this.user + "\n";
            ++i;
        }
        this.cfA = String.valueOf(this.cfA) + "N" + document + "\n";
        this.cfAlen = String.valueOf(this.cfA.length());
        System.out.println(this.cfA);
    }

    private String getNewJobId() {
        return this.fillLeft(String.valueOf((int)Math.floor(Math.random() * 999.0)), 3, "0");
    }

    private String fillLeft(String data, int size, String filler) {
        while (data.length() < size) {
            data = String.valueOf(filler) + data;
        }
        return data;
    }

    private class PrintJob
    extends Thread {
        String queue;
        String document;
        String id;
        int mode;
        private byte[] dfA1 = null;
        private char[] dfA2 = null;

        public PrintJob(String queue, byte[] data, String document) {
            this.queue = queue;
            this.dfA1 = data;
            this.document = document;
            this.mode = 1;
            this.id = LPR.this.getNewJobId();
            LPR.this.jobs.addElement(this.id);
            System.out.println("Printjob (byte) " + this.id + " queue=" + queue + " document=" + document);
        }

        public PrintJob(String queue, char[] data, String document) {
            this.queue = queue;
            this.dfA2 = data;
            this.document = document;
            this.mode = 2;
            this.id = LPR.this.getNewJobId();
            LPR.this.jobs.addElement(this.id);
            System.out.println("Printjob (char) " + this.id + " queue=" + queue + " document=" + document);
        }

        public void run() {
            boolean rc = false;
            int i = 0;
            System.out.println("Printjob (char) " + this.id + " queue=" + this.queue + " document=" + this.document);
            while (!rc) {
                try {
                    ++i;
                    rc = LPR.this.print(this.queue, this.document, this.dfA1, this.dfA2, this.mode, this.id);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                if (!rc && i > 5) break;
                if (rc) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            LPR.this.jobs.removeElement(this.id);
            if (rc) {
                System.out.println("Job " + this.id + " allready printed and removed from queue (" + i + " trys)");
            } else {
                System.out.println("Job " + this.id + " not printed and removed from queue (" + i + " trys)");
            }
        }

        public String getJobId() {
            return this.id;
        }
    }
}

