/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.ThreadAwareExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SingleThreadIoEventLoop
extends SingleThreadEventLoop
implements IoEventLoop {
    private static final long DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS = TimeUnit.MILLISECONDS.toNanos(Math.max(100, SystemPropertyUtil.getInt((String)"io.netty.eventLoop.maxTaskProcessingQuantumMs", (int)1000)));
    private final long maxTaskProcessingQuantumNs;
    private final IoHandlerContext context = new IoHandlerContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return !SingleThreadIoEventLoop.this.hasTasks() && !SingleThreadIoEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.delayNanos(currentTimeNanos);
        }

        @Override
        public long deadlineNanos() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.deadlineNanos();
        }
    };
    private final IoHandler ioHandler;
    private final AtomicInteger numRegistrations = new AtomicInteger();

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory) {
        super((EventLoopGroup)parent, threadFactory, false, true);
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
        this.ioHandler = ((IoHandlerFactory)ObjectUtil.checkNotNull((Object)ioHandlerFactory, (String)"ioHandlerFactory")).newHandler((ThreadAwareExecutor)this);
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandlerFactory ioHandlerFactory) {
        super((EventLoopGroup)parent, executor, false, true);
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
        this.ioHandler = ((IoHandlerFactory)ObjectUtil.checkNotNull((Object)ioHandlerFactory, (String)"ioHandlerFactory")).newHandler((ThreadAwareExecutor)this);
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, long maxTaskProcessingQuantumMs) {
        super((EventLoopGroup)parent, threadFactory, false, true, maxPendingTasks, rejectedExecutionHandler);
        this.maxTaskProcessingQuantumNs = ObjectUtil.checkPositiveOrZero((long)maxTaskProcessingQuantumMs, (String)"maxTaskProcessingQuantumMs") == 0L ? DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS : maxTaskProcessingQuantumMs;
        this.ioHandler = ((IoHandlerFactory)ObjectUtil.checkNotNull((Object)ioHandlerFactory, (String)"ioHandlerFactory")).newHandler((ThreadAwareExecutor)this);
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandlerFactory ioHandlerFactory, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, long maxTaskProcessingQuantumMs) {
        super((EventLoopGroup)parent, executor, false, true, maxPendingTasks, rejectedExecutionHandler);
        this.maxTaskProcessingQuantumNs = ObjectUtil.checkPositiveOrZero((long)maxTaskProcessingQuantumMs, (String)"maxTaskProcessingQuantumMs") == 0L ? DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS : maxTaskProcessingQuantumMs;
        this.ioHandler = ((IoHandlerFactory)ObjectUtil.checkNotNull((Object)ioHandlerFactory, (String)"ioHandlerFactory")).newHandler((ThreadAwareExecutor)this);
    }

    protected SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandlerFactory ioHandlerFactory, Queue<Runnable> taskQueue, Queue<Runnable> tailTaskQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parent, executor, false, true, taskQueue, tailTaskQueue, rejectedExecutionHandler);
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
        this.ioHandler = ((IoHandlerFactory)ObjectUtil.checkNotNull((Object)ioHandlerFactory, (String)"ioHandlerFactory")).newHandler((ThreadAwareExecutor)this);
    }

    protected void run() {
        assert (this.inEventLoop());
        this.ioHandler.initialize();
        do {
            this.runIo();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTaskProcessingQuantumNs);
        } while (!this.confirmShutdown() && !this.canSuspend());
    }

    protected final IoHandler ioHandler() {
        return this.ioHandler;
    }

    protected boolean canSuspend(int state) {
        return super.canSuspend(state) && this.numRegistrations.get() == 0;
    }

    protected int runIo() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public IoEventLoop next() {
        return this;
    }

    @Override
    public final Future<IoRegistration> register(IoHandle handle) {
        Promise promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIo0(handle, (Promise<IoRegistration>)promise);
        } else {
            this.execute(() -> this.registerForIo0(handle, (Promise<IoRegistration>)promise));
        }
        return promise;
    }

    private void registerForIo0(IoHandle handle, Promise<IoRegistration> promise) {
        IoRegistration registration;
        assert (this.inEventLoop());
        try {
            registration = this.ioHandler.register(handle);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return;
        }
        this.numRegistrations.incrementAndGet();
        promise.setSuccess((Object)new IoRegistrationWrapper(registration));
    }

    protected final void wakeup(boolean inEventLoop) {
        this.ioHandler.wakeup();
    }

    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.ioHandler.isCompatible(handleType);
    }

    @Override
    public boolean isIoType(Class<? extends IoHandler> handlerType) {
        return this.ioHandler.getClass().equals(handlerType);
    }

    private final class IoRegistrationWrapper
    implements IoRegistration {
        private final IoRegistration registration;

        IoRegistrationWrapper(IoRegistration registration) {
            this.registration = registration;
        }

        @Override
        public <T> T attachment() {
            return this.registration.attachment();
        }

        @Override
        public long submit(IoOps ops) {
            return this.registration.submit(ops);
        }

        @Override
        public boolean isValid() {
            return this.registration.isValid();
        }

        @Override
        public boolean cancel() {
            if (this.registration.cancel()) {
                SingleThreadIoEventLoop.this.numRegistrations.decrementAndGet();
                return true;
            }
            return false;
        }
    }
}

