/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SocksProxy
extends AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map<IoSession, Proxy> proxies = new ConcurrentHashMap<IoSession, Proxy>();

    public SocksProxy(ConnectionService service) {
        this.service = service;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed: " + this.state);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        Proxy proxy = this.proxies.remove(session);
        if (proxy != null) {
            proxy.close();
        }
    }

    public void messageReceived(IoSession session, Readable message) throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        Proxy proxy = this.proxies.get(session);
        if (proxy == null) {
            int version = buffer.getUByte();
            if (version == 4) {
                proxy = new Socks4(session);
            } else if (version == 5) {
                proxy = new Socks5(session);
            } else {
                throw new IllegalStateException("Unsupported version: " + version);
            }
            proxy.onMessage((Buffer)buffer);
            this.proxies.put(session, proxy);
        } else {
            proxy.onMessage((Buffer)buffer);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.log.warn("Exception caught, closing socks proxy", cause);
        session.close(false);
    }

    public abstract class Proxy
    implements Closeable {
        protected IoSession session;
        protected TcpipClientChannel channel;

        protected Proxy(IoSession session) {
            this.session = session;
        }

        protected void onMessage(Buffer buffer) throws IOException {
            this.session.suspendRead();
            this.channel.getAsyncIn().writeBuffer(buffer).addListener(f -> this.session.resumeRead());
        }

        @Override
        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close(false);
            }
        }

        protected void sendReply(Buffer message, boolean success, LocalWindow window, long windowSize) {
            try {
                this.session.writeBuffer(message);
            }
            catch (IOException e) {
                SocksProxy.this.log.error("Failed ({}) to send channel open response for {}: {}", new Object[]{e.getClass().getSimpleName(), this.channel, e.getMessage()});
                if (success) {
                    SocksProxy.this.service.unregisterChannel(this.channel);
                    this.channel.close(true);
                }
                throw new IllegalStateException("Failed to send packet", e);
            }
            if (success) {
                this.session.resumeRead();
                try {
                    window.release(windowSize);
                }
                catch (IOException e) {
                    SocksProxy.this.log.error("Could not open channel window to {} on channel {}: {}", new Object[]{windowSize, this.channel, e});
                    SocksProxy.this.service.unregisterChannel(this.channel);
                    this.channel.close(true);
                    throw new IllegalStateException("Failed to open window", e);
                }
            }
        }
    }

    public class Socks4
    extends Proxy {
        public Socks4(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            if (this.channel == null) {
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int port = buffer.getUShort();
                String host = Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte());
                String userId = this.getNTString(buffer);
                if (host.startsWith("0.0.0.")) {
                    host = this.getNTString(buffer);
                }
                if (SocksProxy.this.log.isDebugEnabled()) {
                    SocksProxy.this.log.debug("Received socks4 connection request for {} to {}:{}", new Object[]{userId, host, port});
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                LocalWindow window = this.channel.getLocalWindow();
                long windowSize = window.getSize();
                window.consume(windowSize);
                this.channel.open().addListener(f -> this.onChannelOpened((OpenFuture)f, window, windowSize));
            } else {
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future, LocalWindow window, long windowSize) {
            this.session.resumeRead();
            ByteArrayBuffer buffer = new ByteArrayBuffer(64, false);
            buffer.putByte((byte)0);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                buffer.putByte((byte)91);
            } else {
                buffer.putByte((byte)90);
            }
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            this.sendReply((Buffer)buffer, t == null, window, windowSize);
        }

        protected String getNTString(Buffer buffer) {
            StringBuilder sb = new StringBuilder();
            char c = (char)buffer.getUByte();
            while (c != '\u0000') {
                sb.append(c);
                c = (char)buffer.getUByte();
            }
            return sb.toString();
        }
    }

    public class Socks5
    extends Proxy {
        private byte[] authMethods;

        public Socks5(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            boolean debugEnabled = SocksProxy.this.log.isDebugEnabled();
            if (this.authMethods == null) {
                int nbAuthMethods = buffer.getUByte();
                this.authMethods = new byte[nbAuthMethods];
                buffer.getRawBytes(this.authMethods);
                boolean foundNoAuth = false;
                for (int i = 0; i < nbAuthMethods; ++i) {
                    foundNoAuth |= this.authMethods[i] == 0;
                }
                buffer = new ByteArrayBuffer(8, false);
                buffer.putByte((byte)5);
                buffer.putByte((byte)(foundNoAuth ? 0 : 255));
                this.session.writeBuffer(buffer);
                if (!foundNoAuth) {
                    throw new IllegalStateException("Received socks5 greeting without NoAuth method");
                }
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 greeting");
                }
            } else if (this.channel == null) {
                String host;
                int type;
                int version = buffer.getUByte();
                if (version != 5) {
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int res = buffer.getUByte();
                if (res != 0 && debugEnabled) {
                    SocksProxy.this.log.debug("No zero reserved value: {}", (Object)res);
                }
                if ((type = buffer.getUByte()) == 1) {
                    host = Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte()) + "." + Integer.toString(buffer.getUByte());
                } else if (type == 3) {
                    host = this.getBLString(buffer);
                } else if (type == 4) {
                    host = Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort()) + ":" + Integer.toHexString(buffer.getUShort());
                } else {
                    throw new IllegalStateException("Unsupported address type: " + type);
                }
                int port = buffer.getUShort();
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection request to {}:{}", (Object)host, (Object)port);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                LocalWindow window = this.channel.getLocalWindow();
                long windowSize = window.consumeAll();
                this.channel.open().addListener(f -> this.onChannelOpened((OpenFuture)f, window, windowSize));
            } else {
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection message");
                }
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future, LocalWindow window, long windowSize) {
            ByteArrayBuffer response = new ByteArrayBuffer(2);
            response.putByte((byte)5);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                response.putByte((byte)1);
            } else {
                response.putByte((byte)0);
            }
            response.putByte((byte)0);
            SocketAddress bound = this.session.getAcceptanceAddress();
            if (bound instanceof InetSocketAddress) {
                byte[] ip = ((InetSocketAddress)bound).getAddress().getAddress();
                if (ip.length == 4) {
                    response.putByte((byte)1);
                } else {
                    response.putByte((byte)4);
                }
                response.putRawBytes(ip);
                response.putShort(((InetSocketAddress)bound).getPort());
            } else {
                response.putByte((byte)1);
                response.putLong(0L);
                response.putShort(0);
            }
            this.sendReply((Buffer)response, t == null, window, windowSize);
        }

        protected String getBLString(Buffer buffer) {
            int length = buffer.getUByte();
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append((char)buffer.getUByte());
            }
            return sb.toString();
        }
    }
}

