/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.AbstractRecursiveOperationConfiguration;
import org.assertj.core.api.recursive.comparison.DefaultRecursiveComparisonIntrospectionStrategy;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.FieldComparators;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.api.recursive.comparison.FieldMessages;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonIntrospectionStrategy;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.data.MapEntry;
import org.assertj.core.internal.RecursiveHelper;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.internal.TypeMessages;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.VisibleForTesting;

public class RecursiveComparisonConfiguration
extends AbstractRecursiveOperationConfiguration {
    private static final boolean DEFAULT_IGNORE_ALL_OVERRIDDEN_EQUALS = true;
    public static final String INDENT_LEVEL_2 = "  -";
    public static final DefaultRecursiveComparisonIntrospectionStrategy DEFAULT_RECURSIVE_COMPARISON_INTROSPECTION_STRATEGY = new DefaultRecursiveComparisonIntrospectionStrategy();
    private boolean strictTypeChecking = false;
    private boolean ignoreAllActualNullFields = false;
    private boolean ignoreAllActualEmptyOptionalFields = false;
    private boolean ignoreAllExpectedNullFields = false;
    private Set<FieldLocation> comparedFields = new LinkedHashSet<FieldLocation>();
    private Set<Class<?>> comparedTypes = new LinkedHashSet();
    private final List<Class<?>> ignoredOverriddenEqualsForTypes = new ArrayList();
    private List<String> ignoredOverriddenEqualsForFields = new ArrayList<String>();
    private final List<Pattern> ignoredOverriddenEqualsForFieldsMatchingRegexes = new ArrayList<Pattern>();
    private boolean ignoreAllOverriddenEquals = true;
    private boolean ignoreCollectionOrder = false;
    private Set<String> ignoredCollectionOrderInFields = new LinkedHashSet<String>();
    private final List<Pattern> ignoredCollectionOrderInFieldsMatchingRegexes = new ArrayList<Pattern>();
    private TypeComparators typeComparators = TypeComparators.defaultTypeComparators();
    private FieldComparators fieldComparators = new FieldComparators();
    private TypeMessages typeMessages = new TypeMessages();
    private FieldMessages fieldMessages = new FieldMessages();
    private final Set<FieldLocation> fieldLocationsToCompareBecauseOfTypesToCompare = new LinkedHashSet<FieldLocation>();
    private RecursiveComparisonIntrospectionStrategy introspectionStrategy = DEFAULT_RECURSIVE_COMPARISON_INTROSPECTION_STRATEGY;
    private boolean compareEnumAgainstString = false;

    public void registerFieldLocationToCompareBecauseOfTypesToCompare(FieldLocation fieldLocation) {
        this.fieldLocationsToCompareBecauseOfTypesToCompare.add(fieldLocation);
    }

    private RecursiveComparisonConfiguration(Builder builder) {
        super(builder);
        this.ignoreAllActualNullFields = builder.ignoreAllActualNullFields;
        this.ignoreAllActualEmptyOptionalFields = builder.ignoreAllActualEmptyOptionalFields;
        this.strictTypeChecking = builder.strictTypeChecking;
        this.ignoreAllExpectedNullFields = builder.ignoreAllExpectedNullFields;
        this.comparedFields = Sets.newLinkedHashSet(builder.comparedFields);
        this.comparedTypes = Sets.newLinkedHashSet(builder.comparedTypes);
        this.ignoreOverriddenEqualsForTypes(builder.ignoredOverriddenEqualsForTypes);
        this.ignoredOverriddenEqualsForFields = Lists.list(builder.ignoredOverriddenEqualsForFields);
        this.ignoreOverriddenEqualsForFieldsMatchingRegexes(builder.ignoredOverriddenEqualsForFieldsMatchingRegexes);
        this.ignoreAllOverriddenEquals = builder.ignoreAllOverriddenEquals;
        this.ignoreCollectionOrder = builder.ignoreCollectionOrder;
        this.ignoredCollectionOrderInFields = Sets.newLinkedHashSet(builder.ignoredCollectionOrderInFields);
        this.ignoreCollectionOrderInFieldsMatchingRegexes(builder.ignoredCollectionOrderInFieldsMatchingRegexes);
        this.typeComparators = builder.typeComparators;
        this.fieldComparators = builder.fieldComparators;
        this.fieldMessages = builder.fieldMessages;
        this.typeMessages = builder.typeMessages;
        this.introspectionStrategy = builder.introspectionStrategy;
    }

    public RecursiveComparisonConfiguration() {
    }

    public boolean hasComparatorForField(String fieldName) {
        return this.fieldComparators.hasComparatorForField(fieldName);
    }

    public Comparator<?> getComparatorForField(String fieldName) {
        return this.fieldComparators.getComparatorForField(fieldName);
    }

    public boolean hasCustomMessageForField(String fieldName) {
        return this.fieldMessages.hasMessageForField(fieldName);
    }

    public String getMessageForField(String fieldName) {
        return this.fieldMessages.getMessageForField(fieldName);
    }

    public FieldComparators getFieldComparators() {
        return this.fieldComparators;
    }

    public boolean hasComparatorForType(Class<?> keyType) {
        return this.typeComparators.hasComparatorForType(keyType);
    }

    public boolean hasCustomComparators() {
        return !this.typeComparators.isEmpty() || !this.fieldComparators.isEmpty();
    }

    public Comparator<?> getComparatorForType(Class<?> fieldType) {
        return this.typeComparators.getComparatorForType(fieldType);
    }

    public boolean hasCustomMessageForType(Class<?> fieldType) {
        return this.typeMessages.hasMessageForType(fieldType);
    }

    public String getMessageForType(Class<?> fieldType) {
        return this.typeMessages.getMessageForType(fieldType);
    }

    public TypeComparators getTypeComparators() {
        return this.typeComparators;
    }

    Stream<Map.Entry<Class<?>, Comparator<?>>> comparatorByTypes() {
        return this.typeComparators.comparatorByTypes();
    }

    @VisibleForTesting
    boolean getIgnoreAllActualNullFields() {
        return this.ignoreAllActualNullFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllExpectedNullFields() {
        return this.ignoreAllExpectedNullFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllOverriddenEquals() {
        return this.ignoreAllOverriddenEquals;
    }

    public void setIgnoreAllActualEmptyOptionalFields(boolean ignoringAllActualEmptyOptionalFields) {
        this.ignoreAllActualEmptyOptionalFields = ignoringAllActualEmptyOptionalFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllActualEmptyOptionalFields() {
        return this.ignoreAllActualEmptyOptionalFields;
    }

    public void setIgnoreAllActualNullFields(boolean ignoreAllActualNullFields) {
        this.ignoreAllActualNullFields = ignoreAllActualNullFields;
    }

    public void setIgnoreAllExpectedNullFields(boolean ignoreAllExpectedNullFields) {
        this.ignoreAllExpectedNullFields = ignoreAllExpectedNullFields;
    }

    public void compareOnlyFields(String ... fieldNamesToCompare) {
        Stream.of(fieldNamesToCompare).map(FieldLocation::new).forEach(this.comparedFields::add);
    }

    public void compareOnlyFieldsOfTypes(Class<?> ... typesToCompare) {
        Arrays.stream(typesToCompare).map(x$0 -> AbstractRecursiveOperationConfiguration.asWrapperIfPrimitiveType(x$0)).forEach(this.comparedTypes::add);
    }

    public Set<FieldLocation> getComparedFields() {
        return this.comparedFields;
    }

    boolean someComparedFieldsHaveBeenSpecified() {
        return !this.comparedFields.isEmpty();
    }

    boolean isOrIsChildOfAnyComparedFields(FieldLocation currentFieldLocation) {
        return this.comparedFields.stream().anyMatch(comparedField -> comparedField.equals(currentFieldLocation) || comparedField.hasChild(currentFieldLocation));
    }

    public Set<Class<?>> getComparedTypes() {
        return this.comparedTypes;
    }

    public void ignoreAllOverriddenEquals() {
        this.ignoreAllOverriddenEquals = true;
    }

    public void useOverriddenEquals() {
        this.ignoreAllOverriddenEquals = false;
    }

    public void ignoreOverriddenEqualsForFields(String ... fields) {
        List<String> fieldLocations = Lists.list(fields);
        this.ignoredOverriddenEqualsForFields.addAll(fieldLocations);
    }

    public void ignoreOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
        this.ignoredOverriddenEqualsForFieldsMatchingRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public void ignoreOverriddenEqualsForTypes(Class<?> ... types) {
        this.ignoredOverriddenEqualsForTypes.addAll(Lists.list(types));
    }

    @VisibleForTesting
    boolean getIgnoreCollectionOrder() {
        return this.ignoreCollectionOrder;
    }

    public void ignoreCollectionOrder(boolean ignoreCollectionOrder) {
        this.ignoreCollectionOrder = ignoreCollectionOrder;
    }

    public void ignoreCollectionOrderInFields(String ... fieldsToIgnoreCollectionOrder) {
        List<String> fieldLocations = Lists.list(fieldsToIgnoreCollectionOrder);
        this.ignoredCollectionOrderInFields.addAll(fieldLocations);
    }

    public Set<String> getIgnoredCollectionOrderInFields() {
        return this.ignoredCollectionOrderInFields;
    }

    public void ignoreCollectionOrderInFieldsMatchingRegexes(String ... regexes) {
        this.ignoredCollectionOrderInFieldsMatchingRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public List<Pattern> getIgnoredCollectionOrderInFieldsMatchingRegexes() {
        return this.ignoredCollectionOrderInFieldsMatchingRegexes;
    }

    public <T> void registerComparatorForType(Comparator<? super T> comparator, Class<T> type) {
        Objects.requireNonNull(comparator, "Expecting a non null Comparator");
        this.typeComparators.registerComparator(type, comparator);
    }

    public <T> void registerEqualsForType(BiPredicate<? super T, ? super T> equals, Class<T> type) {
        this.registerComparatorForType(RecursiveComparisonConfiguration.toComparator(equals), type);
    }

    public void registerComparatorForFields(Comparator<?> comparator, String ... fieldLocations) {
        Objects.requireNonNull(comparator, "Expecting a non null Comparator");
        Stream.of(fieldLocations).forEach(fieldLocation -> this.fieldComparators.registerComparator((String)fieldLocation, comparator));
    }

    public void registerEqualsForFields(BiPredicate<?, ?> equals, String ... fieldLocations) {
        this.registerComparatorForFields(RecursiveComparisonConfiguration.toComparator(equals), fieldLocations);
    }

    public void registerEqualsForFieldsMatchingRegexes(BiPredicate<?, ?> equals, String ... regexes) {
        this.fieldComparators.registerComparatorForFieldsMatchingRegexes(regexes, RecursiveComparisonConfiguration.toComparator(equals));
    }

    public void registerErrorMessageForFields(String message, String ... fieldLocations) {
        Stream.of(fieldLocations).forEach(fieldLocation -> this.fieldMessages.registerMessage((String)fieldLocation, message));
    }

    public void registerErrorMessageForType(String message, Class<?> clazz) {
        this.typeMessages.registerMessage(clazz, message);
    }

    public void strictTypeChecking(boolean strictTypeChecking) {
        this.strictTypeChecking = strictTypeChecking;
    }

    public boolean isInStrictTypeCheckingMode() {
        return this.strictTypeChecking;
    }

    public List<Class<?>> getIgnoredOverriddenEqualsForTypes() {
        return this.ignoredOverriddenEqualsForTypes;
    }

    public List<String> getIgnoredOverriddenEqualsForFields() {
        return this.ignoredOverriddenEqualsForFields;
    }

    public List<Pattern> getIgnoredOverriddenEqualsForFieldsMatchingRegexes() {
        return this.ignoredOverriddenEqualsForFieldsMatchingRegexes;
    }

    public Stream<Map.Entry<String, Comparator<?>>> comparatorByFields() {
        return this.fieldComparators.comparatorByFields();
    }

    RecursiveComparisonIntrospectionStrategy getIntrospectionStrategy() {
        return this.introspectionStrategy;
    }

    public void setIntrospectionStrategy(RecursiveComparisonIntrospectionStrategy introspectionStrategy) {
        this.introspectionStrategy = introspectionStrategy;
    }

    public void allowComparingEnumAgainstString(boolean compareEnumAgainstString) {
        this.compareEnumAgainstString = compareEnumAgainstString;
    }

    public boolean isComparingEnumAgainstStringAllowed() {
        return this.compareEnumAgainstString;
    }

    public String toString() {
        return this.multiLineDescription(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    public int hashCode() {
        return Objects.hash(this.fieldComparators, this.ignoreAllActualEmptyOptionalFields, this.ignoreAllActualNullFields, this.ignoreAllExpectedNullFields, this.ignoreAllOverriddenEquals, this.ignoreCollectionOrder, this.ignoredCollectionOrderInFields, this.ignoredCollectionOrderInFieldsMatchingRegexes, this.getIgnoredFields(), this.getIgnoredFieldsRegexes(), this.ignoredOverriddenEqualsForFields, this.ignoredOverriddenEqualsForTypes, this.ignoredOverriddenEqualsForFieldsMatchingRegexes, this.getIgnoredTypes(), this.strictTypeChecking, this.typeComparators, this.comparedFields, this.comparedTypes, this.fieldMessages, this.typeMessages, this.compareEnumAgainstString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecursiveComparisonConfiguration other = (RecursiveComparisonConfiguration)obj;
        return Objects.equals(this.fieldComparators, other.fieldComparators) && this.ignoreAllActualEmptyOptionalFields == other.ignoreAllActualEmptyOptionalFields && this.ignoreAllActualNullFields == other.ignoreAllActualNullFields && this.ignoreAllExpectedNullFields == other.ignoreAllExpectedNullFields && this.ignoreAllOverriddenEquals == other.ignoreAllOverriddenEquals && this.ignoreCollectionOrder == other.ignoreCollectionOrder && Objects.equals(this.ignoredCollectionOrderInFields, other.ignoredCollectionOrderInFields) && Objects.equals(this.getIgnoredFields(), other.getIgnoredFields()) && Objects.equals(this.comparedFields, other.comparedFields) && Objects.equals(this.comparedTypes, other.comparedTypes) && Objects.equals(this.getIgnoredFieldsRegexes(), other.getIgnoredFieldsRegexes()) && Objects.equals(this.ignoredOverriddenEqualsForFields, other.ignoredOverriddenEqualsForFields) && Objects.equals(this.ignoredOverriddenEqualsForTypes, other.ignoredOverriddenEqualsForTypes) && Objects.equals(this.ignoredOverriddenEqualsForFieldsMatchingRegexes, other.ignoredOverriddenEqualsForFieldsMatchingRegexes) && Objects.equals(this.getIgnoredTypes(), other.getIgnoredTypes()) && this.strictTypeChecking == other.strictTypeChecking && Objects.equals(this.typeComparators, other.typeComparators) && Objects.equals(this.ignoredCollectionOrderInFieldsMatchingRegexes, other.ignoredCollectionOrderInFieldsMatchingRegexes) && Objects.equals(this.fieldMessages, other.fieldMessages) && Objects.equals(this.typeMessages, other.typeMessages);
    }

    public String multiLineDescription(Representation representation) {
        StringBuilder description = new StringBuilder();
        this.describeIgnoreAllActualNullFields(description);
        this.describeIgnoreAllActualEmptyOptionalFields(description);
        this.describeIgnoreAllExpectedNullFields(description);
        this.describeComparedFields(description);
        this.describeComparedTypes(description);
        this.describeIgnoredFields(description);
        this.describeIgnoredFieldsRegexes(description);
        this.describeIgnoredTypes(description);
        this.describeIgnoredTypesRegexes(description);
        this.describeOverriddenEqualsMethodsUsage(description, representation);
        this.describeIgnoreCollectionOrder(description);
        this.describeIgnoredCollectionOrderInFields(description);
        this.describeIgnoredCollectionOrderInFieldsMatchingRegexes(description);
        this.describeRegisteredComparatorByTypes(description);
        this.describeRegisteredComparatorForFields(description);
        this.describeTypeCheckingStrictness(description);
        this.describeRegisteredErrorMessagesForFields(description);
        this.describeRegisteredErrorMessagesForTypes(description);
        this.describeIntrospectionStrategy(description);
        this.describeCompareEnumAgainstString(description);
        return description.toString();
    }

    boolean shouldNotEvaluate(DualValue dualValue) {
        if (!this.comparedTypes.isEmpty()) {
            return false;
        }
        return this.shouldIgnore(dualValue);
    }

    boolean shouldIgnore(DualValue dualValue) {
        return this.shouldIgnoreFieldBasedOnFieldLocation(dualValue.fieldLocation) || this.shouldIgnoreFieldBasedOnFieldValue(dualValue);
    }

    private boolean shouldBeCompared(DualValue dualValue) {
        if (this.comparedFields.isEmpty() && this.comparedTypes.isEmpty()) {
            return true;
        }
        if (!this.comparedTypes.isEmpty()) {
            return true;
        }
        return this.comparedFields.stream().anyMatch(RecursiveComparisonConfiguration.matchesComparedField(dualValue.fieldLocation));
    }

    private static Predicate<FieldLocation> matchesComparedField(FieldLocation field) {
        return comparedField -> field.isRoot() || field.exactlyMatches((FieldLocation)comparedField) || field.hasParent((FieldLocation)comparedField) || field.hasChild((FieldLocation)comparedField);
    }

    Set<String> getActualChildrenNodeNamesToCompare(DualValue dualValue) {
        Set<String> actualChildrenNodeNames = this.getChildrenNodeNamesOf(dualValue.actual);
        if (!this.comparedTypes.isEmpty()) {
            this.registerFieldLocationOfFieldsOfTypesToCompare(dualValue);
            return actualChildrenNodeNames;
        }
        return actualChildrenNodeNames.stream().filter(fieldName -> !this.shouldIgnoreFieldBasedOnFieldLocation(dualValue.fieldLocation.field((String)fieldName))).map(fieldName -> this.dualValueForField(dualValue, (String)fieldName)).filter(fieldDualValue -> !this.shouldIgnoreFieldBasedOnFieldValue((DualValue)fieldDualValue)).filter(this::shouldBeCompared).map(DualValue::getFieldName).filter(fieldName -> !fieldName.isEmpty()).collect(Collectors.toSet());
    }

    Set<String> getChildrenNodeNamesOf(Object instance) {
        return this.introspectionStrategy.getChildrenNodeNamesOf(instance);
    }

    Object getValue(String name, Object instance) {
        return this.introspectionStrategy.getChildNodeValue(name, instance);
    }

    private boolean shouldIgnoreFieldBasedOnFieldValue(DualValue dualValue) {
        return this.matchesAnIgnoredNullField(dualValue) || this.matchesAnIgnoredFieldType(dualValue) || this.matchesAnIgnoredEmptyOptionalField(dualValue);
    }

    private boolean shouldIgnoreFieldBasedOnFieldLocation(FieldLocation fieldLocation) {
        return this.matchesAnIgnoredField(fieldLocation) || this.matchesAnIgnoredFieldRegex(fieldLocation);
    }

    private DualValue dualValueForField(DualValue parentDualValue, String fieldName) {
        Object expectedFieldValue;
        Object actualFieldValue = this.getValue(fieldName, parentDualValue.actual);
        try {
            expectedFieldValue = this.getValue(fieldName, parentDualValue.expected);
        }
        catch (Exception e) {
            expectedFieldValue = null;
        }
        FieldLocation fieldLocation = parentDualValue.fieldLocation.field(fieldName);
        return new DualValue(fieldLocation, actualFieldValue, expectedFieldValue);
    }

    boolean hasCustomComparator(DualValue dualValue) {
        String fieldName = dualValue.getConcatenatedPath();
        if (this.hasComparatorForField(fieldName)) {
            return true;
        }
        if (dualValue.actual == null && dualValue.expected == null) {
            return false;
        }
        Class<?> valueType = dualValue.actual != null ? dualValue.actual.getClass() : dualValue.expected.getClass();
        return this.hasComparatorForType(valueType);
    }

    boolean shouldIgnoreOverriddenEqualsOf(DualValue dualValue) {
        if (dualValue.fieldLocation.isRoot()) {
            return true;
        }
        if (dualValue.isActualJavaType()) {
            return false;
        }
        if (dualValue.isActualAnEnum()) {
            return false;
        }
        if (this.someComparedFieldsHaveBeenSpecified() && !this.exactlyMatchesAnyComparedFields(dualValue)) {
            return true;
        }
        return this.ignoreAllOverriddenEquals || this.matchesAnIgnoredOverriddenEqualsField(dualValue) || dualValue.actual != null && this.shouldIgnoreOverriddenEqualsOf(dualValue.actual.getClass());
    }

    @VisibleForTesting
    boolean shouldIgnoreOverriddenEqualsOf(Class<?> clazz) {
        return this.matchesAnIgnoredOverriddenEqualsType(clazz);
    }

    boolean shouldIgnoreCollectionOrder(FieldLocation fieldLocation) {
        return this.ignoreCollectionOrder || this.matchesAnIgnoredCollectionOrderInField(fieldLocation) || this.matchesAnIgnoredCollectionOrderInFieldRegex(fieldLocation);
    }

    private void describeComparedFields(StringBuilder description) {
        if (!this.comparedFields.isEmpty()) {
            description.append(String.format("- the comparison was performed on the following fields: %s%n", this.describeComparedFields()));
        }
    }

    private void describeComparedTypes(StringBuilder description) {
        if (!this.comparedTypes.isEmpty()) {
            description.append(String.format("- the comparison was performed on any fields with types: %s%n", this.describeComparedTypes()));
        }
    }

    private void describeIgnoredTypes(StringBuilder description) {
        if (!this.getIgnoredTypes().isEmpty()) {
            description.append(String.format("- the following types were ignored in the comparison: %s%n", this.describeIgnoredTypes()));
        }
    }

    private void describeIgnoredTypesRegexes(StringBuilder description) {
        if (!this.getIgnoredTypesRegexes().isEmpty()) {
            description.append(String.format("- the types matching the following regexes were ignored in the comparison: %s%n", this.describeRegexes(this.getIgnoredTypesRegexes())));
        }
    }

    protected void describeIgnoreAllActualNullFields(StringBuilder description) {
        if (this.ignoreAllActualNullFields) {
            description.append(String.format("- all actual null fields were ignored in the comparison%n", new Object[0]));
        }
    }

    protected void describeIgnoreAllActualEmptyOptionalFields(StringBuilder description) {
        if (this.ignoreAllActualEmptyOptionalFields) {
            description.append(String.format("- all actual empty optional fields were ignored in the comparison (including Optional, OptionalInt, OptionalLong and OptionalDouble)%n", new Object[0]));
        }
    }

    private void describeIgnoreAllExpectedNullFields(StringBuilder description) {
        if (this.ignoreAllExpectedNullFields) {
            description.append(String.format("- all expected null fields were ignored in the comparison%n", new Object[0]));
        }
    }

    private void describeOverriddenEqualsMethodsUsage(StringBuilder description, Representation representation) {
        String header = this.ignoreAllOverriddenEquals ? "- no equals methods were used in the comparison EXCEPT for java JDK types since introspecting JDK types is forbidden in java 17+ (use withEqualsForType to register a specific way to compare a JDK type if you need it)" : "- equals methods were used in the comparison";
        description.append(header);
        if (this.isConfiguredToIgnoreSomeButNotAllOverriddenEqualsMethods()) {
            description.append(String.format(" except for:%n", new Object[0]));
            this.describeIgnoredOverriddenEqualsMethods(description, representation);
        } else {
            description.append(String.format("%n", new Object[0]));
        }
    }

    private void describeIgnoredOverriddenEqualsMethods(StringBuilder description, Representation representation) {
        if (!this.ignoredOverriddenEqualsForFields.isEmpty()) {
            description.append(String.format("%s the following fields: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForFields()));
        }
        if (!this.ignoredOverriddenEqualsForTypes.isEmpty()) {
            description.append(String.format("%s the following types: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForTypes(representation)));
        }
        if (!this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty()) {
            description.append(String.format("%s the fields matching the following regexes: %s%n", INDENT_LEVEL_2, this.describeRegexes(this.ignoredOverriddenEqualsForFieldsMatchingRegexes)));
        }
    }

    private String describeIgnoredOverriddenEqualsForTypes(Representation representation) {
        List<String> fieldsDescription = this.ignoredOverriddenEqualsForTypes.stream().map(representation::toStringOf).collect(Collectors.toList());
        return RecursiveComparisonConfiguration.join(fieldsDescription);
    }

    private String describeIgnoredOverriddenEqualsForFields() {
        return RecursiveComparisonConfiguration.join(this.ignoredOverriddenEqualsForFields);
    }

    private void describeIgnoreCollectionOrder(StringBuilder description) {
        if (this.ignoreCollectionOrder) {
            description.append(String.format("- collection order was ignored in all fields in the comparison%n", new Object[0]));
        }
    }

    private void describeIgnoredCollectionOrderInFields(StringBuilder description) {
        if (!this.ignoredCollectionOrderInFields.isEmpty()) {
            description.append(String.format("- collection order was ignored in the following fields in the comparison: %s%n", this.describeIgnoredCollectionOrderInFields()));
        }
    }

    private void describeIgnoredCollectionOrderInFieldsMatchingRegexes(StringBuilder description) {
        if (!this.ignoredCollectionOrderInFieldsMatchingRegexes.isEmpty()) {
            description.append(String.format("- collection order was ignored in the fields matching the following regexes in the comparison: %s%n", this.describeRegexes(this.ignoredCollectionOrderInFieldsMatchingRegexes)));
        }
    }

    private void describeIntrospectionStrategy(StringBuilder description) {
        description.append(String.format("- the introspection strategy used was: %s%n", this.introspectionStrategy.getDescription()));
    }

    private void describeCompareEnumAgainstString(StringBuilder description) {
        if (this.compareEnumAgainstString) {
            description.append(String.format("- enums can be compared against strings (and vice versa), e.g. Color.RED and \"RED\" are considered equal%n", new Object[0]));
        }
    }

    private boolean matchesAnIgnoredOverriddenEqualsRegex(FieldLocation fieldLocation) {
        if (this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty()) {
            return false;
        }
        String pathToUseInRules = fieldLocation.getPathToUseInRules();
        return this.ignoredOverriddenEqualsForFieldsMatchingRegexes.stream().anyMatch(regex -> regex.matcher(pathToUseInRules).matches());
    }

    private boolean matchesAnIgnoredOverriddenEqualsType(Class<?> clazz) {
        return this.ignoredOverriddenEqualsForTypes.contains(clazz);
    }

    private boolean matchesAnIgnoredOverriddenEqualsField(DualValue dualValue) {
        FieldLocation fieldLocation = dualValue.fieldLocation;
        return this.ignoredOverriddenEqualsForFields.stream().anyMatch(fieldLocation::exactlyMatches) || this.matchesAnIgnoredOverriddenEqualsRegex(fieldLocation);
    }

    private boolean matchesAnIgnoredNullField(DualValue dualValue) {
        return this.ignoreAllActualNullFields && dualValue.actual == null || this.ignoreAllExpectedNullFields && dualValue.expected == null;
    }

    private boolean matchesAnIgnoredEmptyOptionalField(DualValue dualValue) {
        return this.ignoreAllActualEmptyOptionalFields && dualValue.isActualFieldAnEmptyOptionalOfAnyType();
    }

    private boolean matchesAnIgnoredFieldType(DualValue dualValue) {
        Object actual = dualValue.actual;
        if (actual != null) {
            return this.matchesAnIgnoredType(actual);
        }
        Object expected = dualValue.expected;
        if (this.strictTypeChecking && expected != null) {
            return this.matchesAnIgnoredType(expected);
        }
        return false;
    }

    private boolean matchesAnIgnoredType(Object actual) {
        Class<?> actualType = actual.getClass();
        return this.getIgnoredTypes().contains(actualType) || this.getIgnoredTypesRegexes().stream().anyMatch(regex -> regex.matcher(actualType.getName()).matches());
    }

    private void registerFieldLocationOfFieldsOfTypesToCompare(DualValue dualValue) {
        if (this.comparedTypes.isEmpty()) {
            return;
        }
        if (dualValue.actual != null && this.comparedTypes.contains(dualValue.actual.getClass()) || dualValue.expected != null && this.comparedTypes.contains(dualValue.expected.getClass())) {
            this.fieldLocationsToCompareBecauseOfTypesToCompare.add(dualValue.fieldLocation);
        }
    }

    private boolean matchesAnIgnoredCollectionOrderInField(FieldLocation fieldLocation) {
        return this.ignoredCollectionOrderInFields.stream().anyMatch(fieldLocation::exactlyMatches);
    }

    private boolean matchesAnIgnoredCollectionOrderInFieldRegex(FieldLocation fieldLocation) {
        String pathToUseInRules = fieldLocation.getPathToUseInRules();
        return this.ignoredCollectionOrderInFieldsMatchingRegexes.stream().anyMatch(regex -> regex.matcher(pathToUseInRules).matches());
    }

    private String describeComparedFields() {
        return RecursiveComparisonConfiguration.join(this.comparedFields.stream().map(FieldLocation::shortDescription).collect(Collectors.toList()));
    }

    private String describeComparedTypes() {
        List<String> typesDescription = this.comparedTypes.stream().map(Class::getName).collect(Collectors.toList());
        return RecursiveComparisonConfiguration.join(typesDescription);
    }

    private String describeIgnoredCollectionOrderInFields() {
        return RecursiveComparisonConfiguration.join(this.ignoredCollectionOrderInFields);
    }

    private boolean isConfiguredToIgnoreSomeButNotAllOverriddenEqualsMethods() {
        boolean ignoreSomeOverriddenEqualsMethods = !this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty() || !this.ignoredOverriddenEqualsForTypes.isEmpty() || !this.ignoredOverriddenEqualsForFields.isEmpty();
        return !this.ignoreAllOverriddenEquals && ignoreSomeOverriddenEqualsMethods;
    }

    private void describeRegisteredComparatorByTypes(StringBuilder description) {
        if (!this.typeComparators.isEmpty()) {
            description.append(String.format("- these types were compared with the following comparators:%n", new Object[0]));
            this.describeComparatorForTypes(description);
        }
    }

    private void describeComparatorForTypes(StringBuilder description) {
        this.typeComparators.comparatorByTypes().map(this::formatRegisteredComparatorByType).forEach(description::append);
    }

    private String formatRegisteredComparatorByType(Map.Entry<Class<?>, Comparator<?>> next) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, next.getKey().getName(), next.getValue());
    }

    private void describeRegisteredComparatorForFields(StringBuilder description) {
        if (!this.fieldComparators.isEmpty()) {
            if (this.fieldComparators.hasFieldComparators()) {
                description.append(String.format("- these fields were compared with the following comparators:%n", new Object[0]));
                this.describeComparatorForFields(description);
            }
            if (this.fieldComparators.hasRegexFieldComparators()) {
                description.append(String.format("- the fields matching these regexes were compared with the following comparators:%n", new Object[0]));
                this.describeComparatorForRegexFields(description);
            }
            if (this.fieldComparators.hasFieldComparators() && this.fieldComparators.hasRegexFieldComparators()) {
                description.append(String.format("- field comparators take precedence over regex field matching comparators.%n", new Object[0]));
            }
            if (!this.typeComparators.isEmpty()) {
                description.append(String.format("- field comparators take precedence over type comparators.%n", new Object[0]));
            }
        }
    }

    private void describeComparatorForFields(StringBuilder description) {
        this.fieldComparators.comparatorByFields().map(this::formatRegisteredComparatorForField).forEach(description::append);
    }

    private void describeComparatorForRegexFields(StringBuilder description) {
        this.fieldComparators.comparatorByRegexFields().map(this::formatRegisteredComparatorForRegexFields).sorted().forEach(description::append);
    }

    private String formatRegisteredComparatorForField(Map.Entry<String, Comparator<?>> comparatorForField) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, comparatorForField.getKey(), comparatorForField.getValue());
    }

    private String formatRegisteredComparatorForRegexFields(Map.Entry<List<Pattern>, Comparator<?>> comparatorForRegexFields) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, comparatorForRegexFields.getKey(), comparatorForRegexFields.getValue());
    }

    private void describeTypeCheckingStrictness(StringBuilder description) {
        String str = this.strictTypeChecking ? "- actual and expected objects and their fields were considered different when of incompatible types (i.e. expected type does not extend actual's type) even if all their fields match, for example a Person instance will never match a PersonDto (call strictTypeChecking(false) to change that behavior).%n" : "- actual and expected objects and their fields were compared field by field recursively even if they were not of the same type, this allows for example to compare a Person to a PersonDto (call strictTypeChecking(true) to change that behavior).%n";
        description.append(String.format(str, new Object[0]));
    }

    private void describeRegisteredErrorMessagesForFields(StringBuilder description) {
        if (!this.fieldMessages.isEmpty()) {
            description.append(String.format("- these fields had overridden error messages:%n", new Object[0]));
            this.describeErrorMessagesForFields(description);
            if (!this.typeMessages.isEmpty()) {
                description.append(String.format("- field custom messages take precedence over type messages.%n", new Object[0]));
            }
        }
    }

    private void describeErrorMessagesForFields(StringBuilder description) {
        String fields = this.fieldMessages.messageByFields().map(Map.Entry::getKey).collect(Collectors.joining(", "));
        description.append(String.format("%s %s%n", INDENT_LEVEL_2, fields));
    }

    private void describeRegisteredErrorMessagesForTypes(StringBuilder description) {
        if (!this.typeMessages.isEmpty()) {
            description.append("- these types had overridden error messages:%n");
            this.describeErrorMessagesForType(description);
        }
    }

    private void describeErrorMessagesForType(StringBuilder description) {
        String types = this.typeMessages.messageByTypes().map(it -> ((Class)it.getKey()).getName()).collect(Collectors.joining(", "));
        description.append(String.format("%s %s%n", INDENT_LEVEL_2, types));
    }

    public static Builder builder() {
        return new Builder();
    }

    void checkComparedFieldsExist(Object actual) {
        TreeMap<FieldLocation, String> unknownComparedFields = new TreeMap<FieldLocation, String>();
        for (FieldLocation comparedField : this.comparedFields) {
            this.checkComparedFieldExists(actual, comparedField).ifPresent(entry -> unknownComparedFields.put((FieldLocation)entry.getKey(), (String)entry.getValue()));
        }
        if (!unknownComparedFields.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder("The following fields don't exist: ");
            unknownComparedFields.forEach((fieldLocation, nodeName) -> errorMessageBuilder.append(RecursiveComparisonConfiguration.formatUnknownComparedField(fieldLocation, nodeName)));
            throw new IllegalArgumentException(errorMessageBuilder.toString());
        }
    }

    private Optional<Map.Entry<FieldLocation, String>> checkComparedFieldExists(Object actual, FieldLocation comparedFieldLocation) {
        Object node = actual;
        for (int nestingLevel = 0; nestingLevel < comparedFieldLocation.getDecomposedPath().size(); ++nestingLevel) {
            if (node == null) {
                return Optional.empty();
            }
            if (RecursiveHelper.isContainer(node)) {
                return Optional.empty();
            }
            String comparedFieldNodeNameElement = comparedFieldLocation.getDecomposedPath().get(nestingLevel);
            Set<String> nodeNames = this.introspectionStrategy.getChildrenNodeNamesOf(node);
            if (!nodeNames.contains(comparedFieldNodeNameElement)) {
                return Optional.of(MapEntry.entry(comparedFieldLocation, comparedFieldNodeNameElement));
            }
            node = this.introspectionStrategy.getChildNodeValue(comparedFieldNodeNameElement, node);
        }
        return Optional.empty();
    }

    private static String formatUnknownComparedField(FieldLocation fieldLocation, String unknownNodeNameElement) {
        return fieldLocation.isTopLevelField() ? String.format("{%s}", unknownNodeNameElement) : String.format("{%s in %s}", unknownNodeNameElement, fieldLocation);
    }

    boolean hierarchyMatchesAnyComparedTypes(DualValue dualValue) {
        if (this.isFieldOfTypeToCompare(dualValue)) {
            return true;
        }
        return this.fieldLocationsToCompareBecauseOfTypesToCompare.stream().anyMatch(dualValue.fieldLocation::hasParent);
    }

    boolean matchesOrIsChildOfFieldMatchingAnyComparedTypes(DualValue dualValue) {
        return this.fieldLocationsToCompareBecauseOfTypesToCompare.stream().anyMatch(dualValue.fieldLocation::exactlyMatches);
    }

    boolean hasComparedTypes() {
        return !this.comparedTypes.isEmpty();
    }

    private boolean isFieldOfTypeToCompare(DualValue dualValue) {
        Object valueToCheck = dualValue.actual != null ? dualValue.actual : dualValue.expected;
        return valueToCheck != null && this.comparedTypes.contains(valueToCheck.getClass());
    }

    boolean exactlyMatchesAnyComparedFields(DualValue dualValue) {
        return this.comparedFields.stream().anyMatch(comparedField -> comparedField.exactlyMatches(dualValue.fieldLocation));
    }

    private static Comparator toComparator(BiPredicate equals) {
        Objects.requireNonNull(equals, "Expecting a non null BiPredicate");
        return (o1, o2) -> equals.test(o1, o2) ? 0 : 1;
    }

    public static final class Builder
    extends AbstractRecursiveOperationConfiguration.AbstractBuilder<Builder> {
        private boolean strictTypeChecking;
        private boolean ignoreAllActualNullFields;
        private boolean ignoreAllActualEmptyOptionalFields;
        private boolean ignoreAllExpectedNullFields;
        private FieldLocation[] comparedFields = new FieldLocation[0];
        private Class<?>[] comparedTypes = new Class[0];
        private Class<?>[] ignoredOverriddenEqualsForTypes = new Class[0];
        private String[] ignoredOverriddenEqualsForFields = new String[0];
        private String[] ignoredOverriddenEqualsForFieldsMatchingRegexes = new String[0];
        private boolean ignoreAllOverriddenEquals = true;
        private boolean ignoreCollectionOrder;
        private String[] ignoredCollectionOrderInFields = new String[0];
        private String[] ignoredCollectionOrderInFieldsMatchingRegexes = new String[0];
        private final TypeComparators typeComparators = TypeComparators.defaultTypeComparators();
        private final FieldComparators fieldComparators = new FieldComparators();
        private final FieldMessages fieldMessages = new FieldMessages();
        private final TypeMessages typeMessages = new TypeMessages();
        private RecursiveComparisonIntrospectionStrategy introspectionStrategy = DEFAULT_RECURSIVE_COMPARISON_INTROSPECTION_STRATEGY;

        private Builder() {
            super(Builder.class);
        }

        public Builder withStrictTypeChecking(boolean strictTypeChecking) {
            this.strictTypeChecking = strictTypeChecking;
            return this;
        }

        public Builder withIgnoreAllActualNullFields(boolean ignoreAllActualNullFields) {
            this.ignoreAllActualNullFields = ignoreAllActualNullFields;
            return this;
        }

        public Builder withIgnoreAllActualEmptyOptionalFields(boolean ignoreAllActualEmptyOptionalFields) {
            this.ignoreAllActualEmptyOptionalFields = ignoreAllActualEmptyOptionalFields;
            return this;
        }

        public Builder withIgnoreAllExpectedNullFields(boolean ignoreAllExpectedNullFields) {
            this.ignoreAllExpectedNullFields = ignoreAllExpectedNullFields;
            return this;
        }

        public Builder withComparedFields(String ... fieldsToCompare) {
            this.comparedFields = (FieldLocation[])Stream.of(fieldsToCompare).map(FieldLocation::new).toArray(FieldLocation[]::new);
            return this;
        }

        public Builder withComparedTypes(Class<?> ... comparedTypes) {
            this.comparedTypes = comparedTypes;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForTypes(Class<?> ... types) {
            this.ignoredOverriddenEqualsForTypes = types;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForFields(String ... fields) {
            this.ignoredOverriddenEqualsForFields = fields;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
            this.ignoredOverriddenEqualsForFieldsMatchingRegexes = regexes;
            return this;
        }

        public Builder withIgnoreAllOverriddenEquals(boolean ignoreAllOverriddenEquals) {
            this.ignoreAllOverriddenEquals = ignoreAllOverriddenEquals;
            return this;
        }

        public Builder withIgnoreCollectionOrder(boolean ignoreCollectionOrder) {
            this.ignoreCollectionOrder = ignoreCollectionOrder;
            return this;
        }

        public Builder withIgnoredCollectionOrderInFields(String ... fieldsToIgnoreCollectionOrder) {
            this.ignoredCollectionOrderInFields = fieldsToIgnoreCollectionOrder;
            return this;
        }

        public Builder withIgnoredCollectionOrderInFieldsMatchingRegexes(String ... regexes) {
            this.ignoredCollectionOrderInFieldsMatchingRegexes = regexes;
            return this;
        }

        public <T> Builder withComparatorForType(Comparator<? super T> comparator, Class<T> type) {
            Objects.requireNonNull(comparator, "Expecting a non null Comparator");
            this.typeComparators.registerComparator(type, comparator);
            return this;
        }

        public <T> Builder withEqualsForType(BiPredicate<? super T, ? super T> equals, Class<T> type) {
            return this.withComparatorForType(RecursiveComparisonConfiguration.toComparator(equals), type);
        }

        public Builder withComparatorForFields(Comparator<?> comparator, String ... fields) {
            Objects.requireNonNull(comparator, "Expecting a non null Comparator");
            Stream.of(fields).forEach(fieldLocation -> this.fieldComparators.registerComparator((String)fieldLocation, comparator));
            return this;
        }

        public Builder withEqualsForFields(BiPredicate<?, ?> equals, String ... fields) {
            return this.withComparatorForFields(RecursiveComparisonConfiguration.toComparator(equals), fields);
        }

        public Builder withEqualsForFieldsMatchingRegexes(BiPredicate<?, ?> equals, String ... regexes) {
            this.fieldComparators.registerComparatorForFieldsMatchingRegexes(regexes, RecursiveComparisonConfiguration.toComparator(equals));
            return this;
        }

        public Builder withErrorMessageForFields(String message, String ... fields) {
            Stream.of(fields).forEach(fieldLocation -> this.fieldMessages.registerMessage((String)fieldLocation, message));
            return this;
        }

        public Builder withErrorMessageForType(String message, Class<?> type) {
            this.typeMessages.registerMessage(type, message);
            return this;
        }

        @Override
        public Builder withIgnoredFields(String ... fieldsToIgnore) {
            return (Builder)super.withIgnoredFields(fieldsToIgnore);
        }

        @Override
        public Builder withIgnoredFieldsMatchingRegexes(String ... regexes) {
            return (Builder)super.withIgnoredFieldsMatchingRegexes(regexes);
        }

        @Override
        public Builder withIgnoredFieldsOfTypes(Class<?> ... types) {
            return (Builder)super.withIgnoredFieldsOfTypes(types);
        }

        public Builder withIntrospectionStrategy(RecursiveComparisonIntrospectionStrategy introspectionStrategy) {
            this.introspectionStrategy = introspectionStrategy;
            return this;
        }

        public RecursiveComparisonConfiguration build() {
            return new RecursiveComparisonConfiguration(this);
        }
    }
}

