/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import org.apache.maven.settings.building.SettingsProblem;

@Deprecated(since="4.0.0")
public class DefaultSettingsProblem
implements SettingsProblem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String message;
    private final Exception exception;
    private final SettingsProblem.Severity severity;

    public DefaultSettingsProblem(String message, SettingsProblem.Severity severity, String source, int lineNumber, int columnNumber, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : SettingsProblem.Severity.ERROR;
        this.source = source != null ? source : "";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.exception = exception;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getLocation() {
        StringBuilder buffer = new StringBuilder(256);
        if (!this.getSource().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(this.getColumnNumber());
        }
        return buffer.toString();
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        String msg;
        if (this.message != null && !this.message.isEmpty()) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    @Override
    public SettingsProblem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('[').append((Object)this.getSeverity()).append("] ");
        buffer.append(this.getMessage());
        String location = this.getLocation();
        if (!location.isEmpty()) {
            buffer.append(" @ ");
            buffer.append(location);
        }
        return buffer.toString();
    }
}

