/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cli.CommonsCliDaemonMavenOptions;
import org.apache.maven.cli.DaemonMavenCling;
import org.apache.maven.cling.invoker.BaseParser;
import org.apache.maven.cling.invoker.mvn.MavenParser;
import org.mvndaemon.mvnd.common.Environment;

public class DaemonMavenParser
extends MavenParser {
    protected MavenOptions parseArgs(String source, List<String> args) throws ParseException {
        return CommonsCliDaemonMavenOptions.parse(source, args.toArray(new String[0]));
    }

    protected Map<String, String> populateSystemProperties(BaseParser.LocalContext context) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(super.populateSystemProperties(context));
        Map env = (Map)((DaemonMavenCling.Environment)context.parserRequest.lookup().lookup(DaemonMavenCling.Environment.class)).get();
        systemProperties.putAll(env);
        return systemProperties;
    }

    protected List<CoreExtension> readCoreExtensionsDescriptorFromFile(Path extensionsFile) {
        return DaemonMavenParser.filterCoreExtensions(super.readCoreExtensionsDescriptorFromFile(extensionsFile));
    }

    protected static List<CoreExtension> filterCoreExtensions(List<CoreExtension> coreExtensions) {
        String exclusionsString = Environment.MVND_CORE_EXTENSIONS_EXCLUDE.asString();
        Set exclusions = Arrays.stream(exclusionsString.split(",")).filter(e -> !e.trim().isEmpty()).collect(Collectors.toSet());
        if (!exclusions.isEmpty()) {
            return coreExtensions.stream().filter(e -> !exclusions.contains(e.getGroupId() + ":" + e.getArtifactId())).collect(Collectors.toList());
        }
        return coreExtensions;
    }
}

