/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import java.io.File;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import org.eclipse.aether.RequestTrace;

public final class TransferResource {
    private static Clock clock = Clock.systemUTC();
    private final String repositoryId;
    private final String repositoryUrl;
    private final String resourceName;
    private final Object resource;
    private final Path path;
    private final Instant startTime;
    private final RequestTrace trace;
    private long contentLength = -1L;
    private long resumeOffset;

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        TransferResource.clock = clock;
    }

    @Deprecated
    public TransferResource(String repositoryId, String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this(repositoryId, repositoryUrl, resourceName, file != null ? file.toPath() : null, null, trace);
    }

    public TransferResource(String repositoryId, String repositoryUrl, String resourceName, Path path, Object resource, RequestTrace trace) {
        this.repositoryId = repositoryId == null || repositoryId.isEmpty() ? "" : repositoryId;
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.isEmpty() ? "" : (repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.isEmpty() ? "" : (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.path = path;
        this.resource = resource;
        this.trace = trace;
        this.startTime = TransferResource.getClock().instant();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Object getResource() {
        return this.resource;
    }

    @Deprecated
    public File getFile() {
        return this.path != null ? this.path.toFile() : null;
    }

    public Path getPath() {
        return this.path;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public long getResumeOffset() {
        return this.resumeOffset;
    }

    public TransferResource setResumeOffset(long resumeOffset) {
        if (resumeOffset < 0L) {
            throw new IllegalArgumentException("resume offset cannot be negative");
        }
        this.resumeOffset = resumeOffset;
        return this;
    }

    @Deprecated
    public long getTransferStartTime() {
        return this.startTime.toEpochMilli();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + " <> " + this.getPath();
    }
}

