/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;

@Experimental
@Immutable
public interface ArtifactInstallerRequest
extends Request<Session> {
    @Nonnull
    public Collection<ProducedArtifact> getArtifacts();

    @Nonnull
    public static ArtifactInstallerRequestBuilder builder() {
        return new ArtifactInstallerRequestBuilder();
    }

    @Nonnull
    public static ArtifactInstallerRequest build(Session session, Collection<ProducedArtifact> artifacts) {
        return ArtifactInstallerRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).artifacts(Objects.requireNonNull(artifacts, "artifacts cannot be null")).build();
    }

    @NotThreadSafe
    public static class ArtifactInstallerRequestBuilder {
        Session session;
        RequestTrace trace;
        Collection<ProducedArtifact> artifacts = Collections.emptyList();

        ArtifactInstallerRequestBuilder() {
        }

        @Nonnull
        public ArtifactInstallerRequestBuilder session(@Nonnull Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactInstallerRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        @Nonnull
        public ArtifactInstallerRequestBuilder artifacts(@Nullable Collection<ProducedArtifact> artifacts) {
            this.artifacts = artifacts != null ? artifacts : Collections.emptyList();
            return this;
        }

        @Nonnull
        public ArtifactInstallerRequest build() {
            return new DefaultArtifactInstallerRequest(this.session, this.trace, this.artifacts);
        }

        static class DefaultArtifactInstallerRequest
        extends BaseRequest<Session>
        implements ArtifactInstallerRequest {
            private final Collection<ProducedArtifact> artifacts;

            DefaultArtifactInstallerRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull Collection<ProducedArtifact> artifacts) {
                super(session, trace);
                this.artifacts = List.copyOf(Objects.requireNonNull(artifacts, "artifacts cannot be null"));
            }

            @Override
            @Nonnull
            public Collection<ProducedArtifact> getArtifacts() {
                return this.artifacts;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultArtifactInstallerRequest)) return false;
                DefaultArtifactInstallerRequest that = (DefaultArtifactInstallerRequest)o;
                if (!Objects.equals(this.artifacts, that.artifacts)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hashCode(this.artifacts);
            }

            @Override
            public String toString() {
                return "ArtifactInstallerRequest[artifacts=" + String.valueOf(this.artifacts) + "]";
            }
        }
    }
}

