/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.cli.DaemonPlexusContainerCapsuleFactory;
import org.apache.maven.cling.invoker.ContainerCapsuleFactory;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.invoker.mvn.resident.ResidentMavenInvoker;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.logging.BuildEventListener;
import org.apache.maven.logging.LoggingOutputStream;
import org.jline.terminal.TerminalBuilder;
import org.mvndaemon.mvnd.common.Environment;

public class DaemonMavenInvoker
extends ResidentMavenInvoker {
    public DaemonMavenInvoker(ProtoLookup protoLookup) {
        super((Lookup)protoLookup);
    }

    protected void doCreateTerminal(MavenContext context, TerminalBuilder builder) {
        builder.streams((InputStream)context.invokerRequest.stdIn().orElseThrow(), (OutputStream)context.invokerRequest.stdOut().orElseThrow());
        builder.systemOutput(TerminalBuilder.SystemOutput.ForcedSysOut);
        builder.provider("exec");
        if (context.coloredOutput != null) {
            builder.color(context.coloredOutput.booleanValue());
        }
        builder.paused(true);
    }

    protected void doConfigureWithTerminalWithRawStreamsEnabled(MavenContext context) {
        System.setOut(this.printStream((OutputStream)context.invokerRequest.stdOut().orElseThrow()));
        System.setErr(this.printStream((OutputStream)context.invokerRequest.stdErr().orElseThrow()));
    }

    private PrintStream printStream(OutputStream outputStream) {
        if (outputStream instanceof LoggingOutputStream) {
            LoggingOutputStream los = (LoggingOutputStream)outputStream;
            return los.printStream();
        }
        if (outputStream instanceof PrintStream) {
            PrintStream ps = (PrintStream)outputStream;
            return ps;
        }
        return new PrintStream(outputStream);
    }

    protected BuildEventListener doDetermineBuildEventListener(MavenContext context) {
        return (BuildEventListener)context.invokerRequest.lookup().lookup(BuildEventListener.class);
    }

    protected void helpOrVersionAndMayExit(MavenContext context) throws Exception {
        InvokerRequest invokerRequest = context.invokerRequest;
        BuildEventListener buildEventListener = (BuildEventListener)context.invokerRequest.parserRequest().lookup().lookup(BuildEventListener.class);
        if (invokerRequest.options().help().isPresent()) {
            context.invokerRequest.options().displayHelp(invokerRequest.parserRequest(), arg_0 -> ((BuildEventListener)buildEventListener).log(arg_0));
            throw new InvokerException.ExitException(0);
        }
        if (invokerRequest.options().showVersionAndExit().isPresent()) {
            if (invokerRequest.options().quiet().orElse(false).booleanValue()) {
                buildEventListener.log(CLIReportingUtils.showVersionMinimal());
            } else {
                buildEventListener.log(CLIReportingUtils.showVersion());
            }
            throw new InvokerException.ExitException(0);
        }
    }

    protected void preCommands(MavenContext context) throws Exception {
        Options mavenOptions = context.invokerRequest.options();
        if (mavenOptions.verbose().orElse(false).booleanValue() || mavenOptions.showVersion().orElse(false).booleanValue()) {
            ((BuildEventListener)context.invokerRequest.parserRequest().lookup().lookup(BuildEventListener.class)).log(CLIReportingUtils.showVersion());
        }
    }

    protected ContainerCapsuleFactory<MavenContext> createContainerCapsuleFactory() {
        return new DaemonPlexusContainerCapsuleFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(MavenContext context, MavenExecutionRequest request) throws Exception {
        context.logger.info(MessageUtils.builder().a((CharSequence)"Processing build on daemon ").strong((Object)Environment.MVND_ID.asString()).toString());
        context.logger.debug("Daemon status dump:");
        context.logger.debug("CWD: " + String.valueOf(context.invokerRequest.cwd()));
        context.logger.debug("MAVEN_HOME: " + String.valueOf(context.invokerRequest.installationDirectory()));
        context.logger.debug("USER_HOME: " + String.valueOf(context.invokerRequest.userHomeDirectory()));
        context.logger.debug("topDirectory: " + String.valueOf(context.invokerRequest.topDirectory()));
        context.logger.debug("rootDirectory: " + String.valueOf(context.invokerRequest.rootDirectory()));
        try {
            int n = super.doExecute(context, request);
            return n;
        }
        finally {
            LoggingOutputStream.forceFlush((PrintStream)System.out);
            LoggingOutputStream.forceFlush((PrintStream)System.err);
        }
    }
}

