/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RepositoryUriUtils;

public final class LocalRepository
implements ArtifactRepository {
    private final Path basePath;
    private final String type;

    public LocalRepository(String basedir) {
        this.basePath = Paths.get(RepositoryUriUtils.toUri(basedir)).toAbsolutePath();
        this.type = "";
    }

    public LocalRepository(URI basedir) {
        this(basedir != null ? Paths.get(basedir) : null, "");
    }

    @Deprecated
    public LocalRepository(File basedir) {
        this(basedir, "");
    }

    public LocalRepository(Path basePath) {
        this(basePath, "");
    }

    @Deprecated
    public LocalRepository(File basedir, String type) {
        this(basedir != null ? basedir.toPath() : null, type);
    }

    public LocalRepository(Path basePath, String type) {
        this.basePath = basePath;
        this.type = type != null ? type : "";
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "local";
    }

    @Deprecated
    public File getBasedir() {
        return this.basePath != null ? this.basePath.toFile() : null;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public String toString() {
        return this.getBasePath() + " (" + this.getContentType() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LocalRepository that = (LocalRepository)obj;
        return Objects.equals(this.basePath, that.basePath) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + LocalRepository.hash(this.basePath);
        hash = hash * 31 + LocalRepository.hash(this.type);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

