/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.internal.transformation.PomArtifactTransformer;
import org.apache.maven.internal.transformation.TransformerManager;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;

@Singleton
@Named
public class DefaultTransformerManager
implements TransformerManager {
    private final Map<String, PomArtifactTransformer> transformers;

    @Inject
    public DefaultTransformerManager(Map<String, PomArtifactTransformer> transformers) {
        this.transformers = Objects.requireNonNull(transformers);
    }

    @Override
    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        for (PomArtifactTransformer transformer : this.transformers.values()) {
            request = transformer.remapInstallArtifacts(session, request);
        }
        return request;
    }

    @Override
    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        for (PomArtifactTransformer transformer : this.transformers.values()) {
            request = transformer.remapDeployArtifacts(session, request);
        }
        return request;
    }

    @Override
    public void injectTransformedArtifacts(RepositorySystemSession repositorySession, MavenProject currentProject) throws IOException {
        for (PomArtifactTransformer transformer : this.transformers.values()) {
            transformer.injectTransformedArtifacts(repositorySession, currentProject);
        }
    }
}

