/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup;

import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.mvnup.ConsoleIcon;
import org.apache.maven.cling.invoker.mvnup.Goal;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class UpgradeContext
extends LookupContext {
    public Map<String, Goal> goals;
    public List<AttributedString> header;
    public AttributedStyle style;
    public LineReader reader;
    private int indentLevel = 0;
    private String indentString = "  ";

    public UpgradeContext(InvokerRequest invokerRequest, UpgradeOptions upgradeOptions) {
        super(invokerRequest, true, (Options)upgradeOptions);
    }

    public void addInHeader(String text) {
        this.addInHeader(AttributedStyle.DEFAULT, text);
    }

    public void addInHeader(AttributedStyle style, String text) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.style(style).append((CharSequence)text);
        this.header.add(asb.toAttributedString());
    }

    public void indent() {
        ++this.indentLevel;
    }

    public void unindent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString != null ? indentString : "  ";
    }

    private String getCurrentIndent() {
        if (this.indentLevel == 0) {
            return "";
        }
        return this.indentString.repeat(this.indentLevel);
    }

    public void info(String message) {
        this.logger.info(this.getCurrentIndent() + message);
    }

    public void debug(String message) {
        this.logger.debug(this.getCurrentIndent() + message);
    }

    public void println() {
        this.logger.info("");
    }

    public void success(String message) {
        this.logger.info(this.getCurrentIndent() + ConsoleIcon.SUCCESS.getIcon(this.terminal) + " " + message);
    }

    public void failure(String message) {
        this.logger.error(this.getCurrentIndent() + ConsoleIcon.ERROR.getIcon(this.terminal) + " " + message);
    }

    public void warning(String message) {
        this.logger.warn(this.getCurrentIndent() + ConsoleIcon.WARNING.getIcon(this.terminal) + " " + message);
    }

    public void detail(String message) {
        this.logger.info(this.getCurrentIndent() + ConsoleIcon.DETAIL.getIcon(this.terminal) + " " + message);
    }

    public void action(String message) {
        this.logger.info(this.getCurrentIndent() + ConsoleIcon.ACTION.getIcon(this.terminal) + " " + message);
    }

    @Nonnull
    public UpgradeOptions options() {
        return (UpgradeOptions)super.options();
    }
}

