/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javadoc.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.JUnitConverter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestConverter
extends Doclet {
    private static File[] m_fileNames;
    private static List<String> m_classNames;
    private static Map<File, List<MethodDoc>> m_files;
    private static Map<File, List<String>> m_fileLines;
    private static Map<File, String> m_packageNames;
    private static Map<File, Integer> m_typelines;
    private File m_outDir = null;
    private boolean m_useAnnotations;
    private boolean m_done;
    private String[] m_groups;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$testng$junit$JUnitTestConverter;

    public JUnitTestConverter(File[] fileNames, File outDir, String release, boolean useAnnotations, String[] groups) {
        m_fileNames = fileNames;
        this.m_outDir = outDir;
        this.m_useAnnotations = useAnnotations;
        this.m_groups = groups;
        ArrayList<String> argv = new ArrayList<String>();
        argv.add("-quiet");
        if (null != release && !"".equals(release)) {
            argv.add("-source");
            argv.add(release);
        }
        argv.add("-doclet");
        argv.add("org.testng.junit.JUnitTestConverter");
        for (File fn : fileNames) {
            argv.add(fn.getAbsolutePath());
        }
        String[] newArgv = argv.toArray(new String[argv.size()]);
        this.m_done = 0 == Main.execute((String[])newArgv);
    }

    private static File findFileName(ClassDoc cd) {
        for (File fn : m_fileNames) {
            if (!fn.getAbsolutePath().endsWith(new StringBuffer().append(cd.name()).append(".java").toString())) continue;
            return fn;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)new StringBuffer().append("COULDN'T FIND FILE ").append(cd.name()).toString());
        }
        return null;
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classes;
        for (ClassDoc cd : classes = root.classes()) {
            if (!JUnitTestConverter.isJUnitTest(cd)) continue;
            if (!cd.isAbstract()) {
                m_classNames.add(cd.qualifiedTypeName());
            }
            File file = null != cd.position().file() ? cd.position().file() : JUnitTestConverter.findFileName(cd);
            String fqn = cd.qualifiedTypeName();
            int tn = fqn.indexOf(cd.typeName());
            if (tn > 0) {
                m_packageNames.put(file, fqn.substring(0, tn - 1));
            }
            m_typelines.put(file, new Integer(cd.position().line()));
            MethodDoc[] methods = cd.methods();
            ArrayList<MethodDoc> testMethods = new ArrayList<MethodDoc>();
            for (MethodDoc md : methods) {
                if (!JUnitTestConverter.isTest(md) && !JUnitTestConverter.isSetUp(md) && !JUnitTestConverter.isTearDown(md)) continue;
                testMethods.add(0, md);
            }
            m_files.put(file, testMethods);
        }
        return true;
    }

    private static boolean isJUnitTest(ClassDoc clsDoc) {
        if (clsDoc.isInterface()) {
            return false;
        }
        for (ClassDoc superCls = clsDoc.superclass(); null != superCls && !"java.lang.Object".equals(superCls.qualifiedTypeName()); superCls = superCls.superclass()) {
            if (!"junit.framework.TestCase".equals(superCls.qualifiedTypeName()) && !"TestCase".equals(superCls.typeName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTest(MethodDoc md) {
        return md.name().startsWith("test");
    }

    private static boolean isSetUp(MethodDoc md) {
        return "setUp".equals(md.name());
    }

    private static boolean isTearDown(MethodDoc md) {
        return "tearDown".equals(md.name());
    }

    public int convert() {
        if (!this.m_done) {
            return -1;
        }
        int converted = 0;
        for (File file : m_files.keySet()) {
            try {
                List<String> lines = this.fileToLines(file);
                List<String> finalLines = this.m_useAnnotations ? this.insertAnnotations(m_files.get(file), lines) : this.insertJavadoc(file, m_files.get(file), lines);
                m_fileLines.put(file, finalLines);
                this.writeFile(file);
                ++converted;
            }
            catch (IOException ioe) {
                JUnitTestConverter.ppp(new StringBuffer().append("failed to process ").append(file).toString());
                ioe.printStackTrace();
            }
        }
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File filePath) {
        String fileName = filePath.getName();
        File file = new File(this.getPackageOutputDir(this.m_outDir, m_packageNames.get(filePath)), fileName);
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            List<String> lines = m_fileLines.get(filePath);
            if (!$assertionsDisabled && null == lines) {
                throw new AssertionError((Object)new StringBuffer().append("NO LINES FOR ").append(filePath).toString());
            }
            for (String l : lines) {
                bw.write(l);
                bw.write(10);
            }
            JUnitTestConverter.ppp(new StringBuffer().append("Wrote ").append(file.getAbsolutePath()).toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (null != fw) {
                    fw.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private List<String> insertAnnotations(List<MethodDoc> methodDocs, List<String> lines) {
        int lineCount = 0;
        for (String line : lines) {
            ++lineCount;
            if (!(line = line.trim()).startsWith("import")) continue;
            lines.add(lineCount - 1, "import org.testng.annotations.Test;");
            lines.add(lineCount - 1, "import org.testng.annotations.BeforeMethod;");
            lines.add(lineCount - 1, "import org.testng.annotations.AfterMethod;");
            break;
        }
        String groupsLine = this.createGroupsLine(this.m_groups);
        for (MethodDoc md : methodDocs) {
            SourcePosition sp = md.position();
            int line = sp.line() + 2;
            if (JUnitTestConverter.isTest(md)) {
                lines.add(line, new StringBuffer().append("  @Test").append(groupsLine).toString());
                continue;
            }
            if (JUnitTestConverter.isSetUp(md)) {
                JUnitTestConverter.ppp(new StringBuffer().append("ADDING NEW BEFORE AT ").append(line).toString());
                lines.add(line, new StringBuffer().append("  @BeforeMethod").append(groupsLine).toString());
                continue;
            }
            if (!JUnitTestConverter.isTearDown(md)) continue;
            lines.add(line, new StringBuffer().append("  @AfterMethod").append(groupsLine).toString());
        }
        return lines;
    }

    private String createGroupsLine(String[] groups) {
        StringBuffer result = new StringBuffer();
        if (groups != null) {
            result.append("(groups = {");
            for (int i = 0; i < groups.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(new StringBuffer().append("\"").append(groups[i]).append("\"").toString());
            }
            result.append("})");
        }
        return result.toString();
    }

    private List<String> insertJavadoc(File file, List<MethodDoc> methodDocs, List<String> lines) {
        for (int i = 0; i < methodDocs.size(); ++i) {
            int realInsert;
            MethodDoc md = methodDocs.get(i);
            int insertLineNo = i + 1 < methodDocs.size() ? this.findCommentLine(lines, md, methodDocs.get(i + 1).position().line()) : this.findCommentLine(lines, md, m_typelines.get(file));
            int n = realInsert = insertLineNo == 0 ? md.position().line() - 1 : insertLineNo;
            if (insertLineNo == 0) {
                lines.add(realInsert, "    */");
            }
            if (JUnitTestConverter.isTest(md)) {
                lines.add(realInsert, "    * @testng.test");
            } else if (JUnitTestConverter.isSetUp(md)) {
                lines.add(realInsert, "    * @testng.before-method");
            } else if (JUnitTestConverter.isTearDown(md)) {
                lines.add(realInsert, "    * @testng.after-method");
            }
            if (insertLineNo != 0) continue;
            lines.add(realInsert, "   /**");
        }
        return lines;
    }

    private File getPackageOutputDir(File outDir, String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        return new File(outDir, packageName.replace('.', File.separatorChar));
    }

    private int findCommentLine(List<String> lines, MethodDoc md, int minLine) {
        for (int i = md.position().line() - 1; i > minLine; --i) {
            String line = lines.get(i);
            if (line.indexOf("*/") != -1 && line.indexOf("/**") == -1) {
                return i;
            }
            if (line.indexOf("*/") == -1 || line.indexOf("/**") == -1) continue;
            StringBuffer buf = new StringBuffer(line);
            int idx = buf.indexOf("*/");
            buf.deleteCharAt(idx).deleteCharAt(idx);
            lines.set(i, buf.toString());
            lines.add(i + 1, "    */");
            return i + 1;
        }
        return 0;
    }

    private List<String> fileToLines(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (null != line) {
            result.add(line);
            line = br.readLine();
        }
        return result;
    }

    private static void ppp(String s) {
        if (JUnitConverter.getLogLevel() >= 1) {
            System.out.println(new StringBuffer().append("[JUnitTestConverter]").append(s).toString());
        }
    }

    public String[] getClassNames() {
        return m_classNames.toArray(new String[m_classNames.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$testng$junit$JUnitTestConverter == null ? (class$org$testng$junit$JUnitTestConverter = JUnitTestConverter.class$("org.testng.junit.JUnitTestConverter")) : class$org$testng$junit$JUnitTestConverter).desiredAssertionStatus();
        m_fileNames = null;
        m_classNames = new ArrayList<String>();
        m_files = new HashMap<File, List<MethodDoc>>();
        m_fileLines = new HashMap<File, List<String>>();
        m_packageNames = new HashMap<File, String>();
        m_typelines = new HashMap<File, Integer>();
    }
}

