/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.nuxeo;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.nuxeo.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.user.User;
import org.nuxeo.client.spi.NuxeoClientException;

public class NuxeoAuthorityConnector
extends BaseAuthorityConnector {
    private static final String CONF_SERVER_TAB_PROPERTY = "NuxeoAuthorityConnector.Server";
    private static final String PARAMETER_PREFIX = "nuxeo_";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_conf.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_conf_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_conf.html";
    protected String protocol = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    protected String username = null;
    protected String password = null;
    private NuxeoClient nuxeoClient = null;
    private long lastSessionFetch = -1L;
    private static final long timeToRelease = 300000L;

    void setNuxeoClient(NuxeoClient nuxeoClient) {
        this.nuxeoClient = nuxeoClient;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.protocol = this.params.getParameter("protocol");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
    }

    public void disconnect() throws ManifoldCFException {
        this.shutdownNuxeoClient();
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.username = null;
        this.password = null;
        super.disconnect();
    }

    public String check() throws ManifoldCFException {
        try {
            this.initNuxeoClient();
        }
        catch (NuxeoClientException ex) {
            return "Connection failed: " + ex.getMessage();
        }
        return super.check();
    }

    private void initNuxeoClient() throws ManifoldCFException {
        if (this.nuxeoClient == null) {
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (StringUtils.isEmpty((String)this.host)) {
                throw new ManifoldCFException("Parameter host required but not set");
            }
            String url = this.getUrl();
            this.nuxeoClient = new NuxeoClient.Builder().url(url).authentication(this.username, this.password).connect();
        }
    }

    private void shutdownNuxeoClient() {
        if (this.nuxeoClient != null) {
            this.nuxeoClient.disconnect();
            this.nuxeoClient = null;
            this.lastSessionFetch = -1L;
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastSessionFetch + 300000L) {
            this.shutdownNuxeoClient();
        }
    }

    String getUrl() throws ManifoldCFException {
        int portInt;
        if (this.port != null && this.port.length() > 0) {
            try {
                portInt = Integer.parseInt(this.port);
            }
            catch (NumberFormatException formatException) {
                throw new ManifoldCFException("Port Format Error: " + formatException.getMessage(), (Throwable)formatException);
            }
        } else {
            portInt = this.protocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
        }
        return this.protocol + "://" + this.host + ":" + portInt + "/" + this.path;
    }

    public boolean isConnected() {
        return this.nuxeoClient != null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NuxeoAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    private static void fillInServerConfigurationMap(Map<String, String> serverMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String nuxeoProtocol = parameters.getParameter("protocol");
        String nuxeoHost = parameters.getParameter("host");
        String nuxeoPort = parameters.getParameter("port");
        String nuxeoPath = parameters.getParameter("path");
        String nuxeoUsername = parameters.getParameter("username");
        String nuxeoPassword = parameters.getObfuscatedParameter("password");
        if (nuxeoProtocol == null) {
            nuxeoProtocol = "http";
        }
        if (nuxeoHost == null) {
            nuxeoHost = "";
        }
        if (nuxeoPort == null) {
            nuxeoPort = "8080";
        }
        if (nuxeoPath == null) {
            nuxeoPath = "/nuxeo";
        }
        if (nuxeoUsername == null) {
            nuxeoUsername = "";
        }
        nuxeoPassword = nuxeoPassword == null ? "" : mapper.mapPasswordToKey(nuxeoPassword);
        serverMap.put("nuxeo_protocol", nuxeoProtocol);
        serverMap.put("nuxeo_host", nuxeoHost);
        serverMap.put("nuxeo_port", nuxeoPort);
        serverMap.put("nuxeo_path", nuxeoPath);
        serverMap.put("nuxeo_username", nuxeoUsername);
        serverMap.put("nuxeo_password", nuxeoPassword);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NuxeoAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        NuxeoAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
    }

    public String processConfigurationPost(IThreadContext thredContext, IPostParameters variableContext, ConfigParams parameters) {
        String nuxeoPassword;
        String nuxeoUsername;
        String nuxeoPath;
        String nuxeoPort;
        String nuxeoHost;
        String nuxeoProtocol = variableContext.getParameter("nuxeo_protocol");
        if (nuxeoProtocol != null) {
            parameters.setParameter("protocol", nuxeoProtocol);
        }
        if ((nuxeoHost = variableContext.getParameter("nuxeo_host")) != null) {
            parameters.setParameter("host", nuxeoHost);
        }
        if ((nuxeoPort = variableContext.getParameter("nuxeo_port")) != null) {
            parameters.setParameter("port", nuxeoPort);
        }
        if ((nuxeoPath = variableContext.getParameter("nuxeo_path")) != null) {
            parameters.setParameter("path", nuxeoPath);
        }
        if ((nuxeoUsername = variableContext.getParameter("nuxeo_username")) != null) {
            parameters.setParameter("username", nuxeoUsername);
        }
        if ((nuxeoPassword = variableContext.getParameter("nuxeo_password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(nuxeoPassword));
        }
        return null;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public AuthorizationResponse getAuthorizationResponse(String username) throws ManifoldCFException {
        this.initNuxeoClient();
        try {
            List<String> authorities = this.getGroupsByUser(username);
            if (authorities == null || authorities.isEmpty()) {
                return RESPONSE_USERNOTFOUND;
            }
            return new AuthorizationResponse(authorities.toArray(new String[0]), 0);
        }
        catch (NuxeoClientException e) {
            return RESPONSE_UNREACHABLE;
        }
    }

    List<String> getGroupsByUser(String username) {
        List authorities = null;
        User user = this.nuxeoClient.userManager().fetchUser(username);
        if (user != null) {
            authorities = user.getGroups();
            authorities.add(user.getUserName());
        }
        return authorities;
    }
}

