/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SynchronizeOutputs
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: SynchronizeOutputs.java 988245 2010-08-23 18:39:35Z kwright $";

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IOutputConnectorManager mgr = OutputConnectorManagerFactory.make(tc);
        IOutputConnectionManager connManager = OutputConnectionManagerFactory.make(tc);
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String className = (String)row.getValue("classname");
            try {
                OutputConnectorFactory.getConnectorNoCheck(className);
            }
            catch (ManifoldCFException e) {
                database.beginTransaction();
                try {
                    String[] connectionNames = connManager.findConnectionsForConnector(className);
                    AgentManagerFactory.noteOutputConnectorDeregistration(tc, connectionNames);
                    mgr.removeConnector(className);
                }
                catch (ManifoldCFException e2) {
                    database.signalRollback();
                    throw e2;
                }
                catch (Error e2) {
                    database.signalRollback();
                    throw e2;
                }
                finally {
                    database.endTransaction();
                }
            }
        }
        Logging.root.info((Object)"Successfully synchronized all outputs");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: SynchronizeOutputs");
            System.exit(1);
        }
        try {
            SynchronizeOutputs synchronizeOutputs = new SynchronizeOutputs();
            synchronizeOutputs.execute();
            System.err.println("Successfully synchronized all outputs");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

