/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ListJobs {
    public static final String _rcsid = "@(#)$Id: ListJobs.java 988245 2010-08-23 18:39:35Z kwright $";

    private ListJobs() {
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            System.err.println("Usage: ListJobs");
            System.err.println("");
            System.err.println("The result will be printed to standard out, will be UTF-8 encoded, and will contain the following columns:");
            System.err.println("    identifier,description,connection,startmode,runmode,hopcountmode,priority,rescaninterval,expirationinterval,reseedinterval");
            System.exit(1);
        }
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription[] jobs = jobManager.getAllJobs();
            int i = 0;
            while (i < jobs.length) {
                IJobDescription job = jobs[i++];
                UTF8Stdout.println((Object)(job.getID().toString() + "," + (job.getDescription() == null ? "" : ListJobs.commaEscape(job.getDescription())) + "," + ListJobs.commaEscape(job.getConnectionName()) + "," + ListJobs.startModeMap(job.getStartMethod()) + "," + ListJobs.runModeMap(job.getType()) + "," + ListJobs.hopcountModeMap(job.getHopcountMode()) + "," + Integer.toString(job.getPriority()) + "," + ListJobs.presentInterval(job.getInterval()) + "," + ListJobs.presentInterval(job.getExpiration()) + "," + ListJobs.presentInterval(job.getReseedInterval())));
            }
            System.err.println("Job list done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected static String presentInterval(Long interval) {
        if (interval == null) {
            return "infinite";
        }
        return interval.toString();
    }

    protected static String startModeMap(int startMethod) {
        switch (startMethod) {
            case 0: {
                return "schedule window start";
            }
            case 1: {
                return "schedule window anytime";
            }
            case 2: {
                return "manual";
            }
        }
        return "unknown";
    }

    protected static String runModeMap(int type) {
        switch (type) {
            case 0: {
                return "continuous";
            }
            case 1: {
                return "scan once";
            }
        }
        return "unknown";
    }

    protected static String hopcountModeMap(int mode) {
        switch (mode) {
            case 0: {
                return "accurate";
            }
            case 1: {
                return "no delete";
            }
            case 2: {
                return "never delete";
            }
        }
        return "unknown";
    }

    protected static String commaEscape(String input) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\\' || x == ',') {
                output.append("\\");
            }
            output.append(x);
        }
        return output.toString();
    }
}

