/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.searchblox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxException;
import org.apache.manifoldcf.crawler.system.Logging;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchBloxDocument {
    static final String API_KEY = "apikey";
    static final String SEARCHBLOX_COLLECTION = "collection";
    static final String DATE_FORMAT = "dd MMMM yyyy HH:mm:ss z";
    static final List<String> xmlElements = Lists.newArrayList((Object[])new String[]{"searchblox", "document", "url", "title", "keywords", "content", "description", "lastmodified", "size", "alpha", "contenttype", "category", "meta", "uid"});
    static final String COLNAME_ATTRIBUTE = "colname";
    static final String APIKEY_ATTRIBUTE = "apikey";
    static final String NAME_ATTRIBUTE = "name";
    static final String UID_ATTRIBUTE = "uid";
    static final String BOOST_ATTRIBUTE = "boost";
    private Multimap<String, Object> data_fields = HashMultimap.create();
    String apiKey;
    String colName;
    String uid;

    public SearchBloxDocument(String apikey) {
        this.apiKey = apikey;
    }

    public SearchBloxDocument(String apikey, String documentURI, RepositoryDocument rd, Map<String, List<String>> args) {
        this(apikey);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ROOT);
        this.uid = documentURI;
        this.colName = args.get(SEARCHBLOX_COLLECTION).get(0);
        Date date = rd.getModifiedDate();
        if (date != null) {
            this.data_fields.put((Object)xmlElements.get(7), (Object)dateFormat.format(rd.getModifiedDate()));
        }
        String content = "";
        try {
            content = rd.getField(xmlElements.get(5)) != null ? (String)rd.getField(xmlElements.get(5))[0] : this.buildString(rd.getBinaryStream());
        }
        catch (IOException e) {
            Logging.connectors.error((Object)"[Parsing Content]Content is not text plain, verify you are properly using Apache Tika Transformer", (Throwable)e);
        }
        this.data_fields.put((Object)xmlElements.get(5), (Object)this.clean(content));
        this.data_fields.put((Object)xmlElements.get(10), (Object)rd.getMimeType());
        this.data_fields.put((Object)xmlElements.get(8), (Object)("" + rd.getBinaryLength()));
        for (String boostId : args.keySet()) {
            List<String> argBoost;
            if (!boostId.endsWith("_boost") || (argBoost = args.get(boostId)) == null || argBoost.isEmpty()) continue;
            this.data_fields.put((Object)boostId, (Object)argBoost.get(0));
        }
        HashMultimap metadata = HashMultimap.create();
        Iterator it = rd.getFields();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                String[] values;
                for (String value : values = rd.getFieldAsStrings(name)) {
                    String key = name.toLowerCase(Locale.ROOT);
                    int indexOf = xmlElements.indexOf(key);
                    if (indexOf == 5) continue;
                    if (indexOf != -1 && indexOf != 0 && indexOf != 7 && indexOf != 8) {
                        this.data_fields.put((Object)key, (Object)value);
                        continue;
                    }
                    metadata.put((Object)name, (Object)value);
                }
            }
            catch (IOException e) {
                Logging.connectors.error((Object)("[Getting Field Values]Impossible to read value for metadata " + name), (Throwable)e);
            }
        }
        Iterator aclTypes = rd.securityTypesIterator();
        while (aclTypes.hasNext()) {
            String[] deny_tokens;
            String[] allow_tokens;
            String aclType = (String)aclTypes.next();
            for (String token : allow_tokens = rd.getSecurityACL(aclType)) {
                metadata.put((Object)(aclType + "_allow"), (Object)token);
            }
            for (String token : deny_tokens = rd.getSecurityDenyACL(aclType)) {
                metadata.put((Object)(aclType + "_deny"), (Object)token);
            }
        }
        this.data_fields.put((Object)xmlElements.get(12), (Object)metadata);
    }

    private String clean(String content) {
        content = content.replaceAll("(\r\n|\n)", " ");
        String cleanContent = Jsoup.parseBodyFragment((String)content).text();
        return cleanContent;
    }

    private String buildString(InputStream binaryStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)binaryStream, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    public String toString(IndexingFormat format, DocumentAction action) throws SearchBloxException {
        if (format == IndexingFormat.XML) {
            return this.toStringXML(action);
        }
        return this.toStringJSON(action);
    }

    private String toStringJSON(DocumentAction action) throws SearchBloxException {
        JSONObject result = new JSONObject();
        if (this.apiKey == null) {
            throw new SearchBloxException("The API Key for accessing SearchBlox Server CAN'T be NULL");
        }
        result.put((Object)"apikey", (Object)this.apiKey);
        JSONObject document = new JSONObject();
        if (this.colName == null) {
            throw new SearchBloxException("The Collection Name of the SearchBlox Server CAN'T be NULL");
        }
        document.put((Object)COLNAME_ATTRIBUTE, (Object)this.colName);
        document.put((Object)UID_ATTRIBUTE, (Object)this.uid);
        if (action == DocumentAction.ADD_UPDATE) {
            Multimap metadata;
            for (String element : xmlElements) {
                Object next;
                String value;
                Collection values;
                if (element.equals(xmlElements.get(12)) || (values = this.data_fields.get((Object)element)) == null || values.size() <= 0 || (value = (String)(next = values.iterator().next())) == null || value.isEmpty()) continue;
                if (element.equals("keywords")) {
                    document.put((Object)element, (Object)StringUtils.join((Collection)values, (char)','));
                    continue;
                }
                document.put((Object)element, (Object)value);
            }
            Collection metadataSet = this.data_fields.get((Object)xmlElements.get(12));
            JSONObject metaObject = new JSONObject();
            if (metadataSet != null && metadataSet.size() > 0 && (metadata = (Multimap)metadataSet.iterator().next()) != null && !metadata.isEmpty()) {
                for (String name : metadata.keySet()) {
                    JSONArray nextMetadata = new JSONArray();
                    for (String value : metadata.get((Object)name)) {
                        nextMetadata.add((Object)value);
                    }
                    metaObject.put((Object)name, (Object)nextMetadata);
                }
            }
            document.put((Object)xmlElements.get(12), (Object)metaObject);
        }
        result.put((Object)xmlElements.get(1), (Object)document);
        return result.toJSONString();
    }

    private String toStringXML(DocumentAction action) throws SearchBloxException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new SearchBloxException(e);
        }
        Element root = doc.createElement(xmlElements.get(0));
        if (this.apiKey == null) {
            throw new SearchBloxException("The API Key for accessing SearchBlox Server CAN'T be NULL");
        }
        root.setAttribute("apikey", this.apiKey);
        doc.appendChild(root);
        Element document = doc.createElement(xmlElements.get(1));
        if (this.colName == null) {
            throw new SearchBloxException("The Collection Name of the SearchBlox Server CAN'T be NULL");
        }
        document.setAttribute(COLNAME_ATTRIBUTE, this.colName);
        if (action == DocumentAction.DELETE) {
            document.setAttribute(UID_ATTRIBUTE, this.uid);
        }
        root.appendChild(document);
        if (action == DocumentAction.ADD_UPDATE) {
            Multimap metadata;
            if (this.uid != null && !this.uid.isEmpty()) {
                Element uidElement = doc.createElement(xmlElements.get(13));
                uidElement.setTextContent(this.uid);
                document.appendChild(uidElement);
            }
            for (String element : xmlElements) {
                Object next;
                String value;
                Collection values;
                if (element.equals(xmlElements.get(12)) || (values = this.data_fields.get((Object)element)) == null || values.size() <= 0 || (value = (String)(next = values.iterator().next())) == null || value.isEmpty()) continue;
                Element eValue = doc.createElement(element);
                if (element.equals("keywords")) {
                    eValue.setTextContent(StringUtils.join((Collection)values, (char)','));
                } else {
                    eValue.setTextContent(value);
                }
                Collection boostElement = this.data_fields.get((Object)(element + "_boost"));
                if (boostElement != null && boostElement.size() > 0) {
                    String value_boost = (String)boostElement.iterator().next();
                    eValue.setAttribute(BOOST_ATTRIBUTE, value_boost);
                }
                document.appendChild(eValue);
            }
            Collection metadataSet = this.data_fields.get((Object)xmlElements.get(12));
            if (metadataSet != null && metadataSet.size() > 0 && (metadata = (Multimap)metadataSet.iterator().next()) != null && !metadata.isEmpty()) {
                for (String name : metadata.keySet()) {
                    for (String value : metadata.get((Object)name)) {
                        Element metaElement = doc.createElement(xmlElements.get(12));
                        metaElement.setAttribute(NAME_ATTRIBUTE, name);
                        metaElement.setTextContent(value);
                        document.appendChild(metaElement);
                    }
                }
            }
        }
        return this.getStringFromDocument(doc);
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static enum DocumentAction {
        ADD_UPDATE,
        DELETE,
        STATUS,
        CREATE,
        CLEAR;

    }

    public static enum IndexingFormat {
        JSON,
        XML;

    }
}

