/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public abstract class AbstractTransactionManagerFactory
implements TransactionManagerFactory {
    private static final Log LOG = LogFactory.getLog((Class)AbstractTransactionManagerFactory.class);

    public abstract String getFactoryClassName();

    public abstract String getFactoryMethodName();

    public final TransactionManager getTransactionManager(Properties properties) throws TransactionManagerAcquireException {
        TransactionManager transactionManager;
        try {
            Class<?> factory = Class.forName(this.getFactoryClassName());
            Method method = factory.getMethod(this.getFactoryMethodName(), null);
            Object obj = method.invoke(factory, (Object[])null);
            transactionManager = (TransactionManager)obj;
        }
        catch (Exception ex) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + this.getName();
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        if (transactionManager == null) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + this.getName();
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return transactionManager;
    }
}

