/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.HHErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.util.HHUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureEncodingStep
extends HHErasureCodingStep {
    private int[] piggyBackIndex;
    private RawErasureEncoder rsRawEncoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureEncodingStep(ECBlock[] inputBlocks, ECBlock[] outputBlocks, RawErasureEncoder rsRawEncoder, RawErasureEncoder xorRawEncoder) {
        super(inputBlocks, outputBlocks);
        this.rsRawEncoder = rsRawEncoder;
        this.xorRawEncoder = xorRawEncoder;
        this.piggyBackIndex = HHUtil.initPiggyBackIndexWithoutPBVec(rsRawEncoder.getNumDataUnits(), rsRawEncoder.getNumParityUnits());
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) throws IOException {
        ByteBuffer[] inputBuffers = ECChunk.toBuffers(inputChunks);
        ByteBuffer[] outputBuffers = ECChunk.toBuffers(outputChunks);
        this.performCoding(inputBuffers, outputBuffers);
    }

    private void performCoding(ByteBuffer[] inputs, ByteBuffer[] outputs) throws IOException {
        int numDataUnits = this.rsRawEncoder.getNumDataUnits();
        int numParityUnits = this.rsRawEncoder.getNumParityUnits();
        int subSPacketSize = this.getSubPacketSize();
        if (inputs.length != numDataUnits * subSPacketSize) {
            throw new IllegalArgumentException("Invalid inputs length");
        }
        if (outputs.length != numParityUnits * subSPacketSize) {
            throw new IllegalArgumentException("Invalid outputs length");
        }
        ByteBuffer[][] hhInputs = new ByteBuffer[subSPacketSize][numDataUnits];
        for (int i = 0; i < subSPacketSize; ++i) {
            for (int j = 0; j < numDataUnits; ++j) {
                hhInputs[i][j] = inputs[i * numDataUnits + j];
            }
        }
        ByteBuffer[][] hhOutputs = new ByteBuffer[subSPacketSize][numParityUnits];
        for (int i = 0; i < subSPacketSize; ++i) {
            for (int j = 0; j < numParityUnits; ++j) {
                hhOutputs[i][j] = outputs[i * numParityUnits + j];
            }
        }
        this.doEncode(hhInputs, hhOutputs);
    }

    private void doEncode(ByteBuffer[][] inputs, ByteBuffer[][] outputs) throws IOException {
        int numParityUnits = this.rsRawEncoder.getNumParityUnits();
        ByteBuffer[] piggyBacks = HHUtil.getPiggyBacksFromInput(inputs[0], this.piggyBackIndex, numParityUnits, 0, this.xorRawEncoder);
        for (int i = 0; i < this.getSubPacketSize(); ++i) {
            this.rsRawEncoder.encode(inputs[i], outputs[i]);
        }
        this.encodeWithPiggyBacks(piggyBacks, outputs, numParityUnits, inputs[0][0].isDirect());
    }

    private void encodeWithPiggyBacks(ByteBuffer[] piggyBacks, ByteBuffer[][] outputs, int numParityUnits, boolean bIsDirect) {
        if (!bIsDirect) {
            for (int i = 0; i < numParityUnits - 1; ++i) {
                int offset;
                int parityIndex = i + 1;
                int bufSize = piggyBacks[i].remaining();
                byte[] newOut = outputs[1][parityIndex].array();
                int k = offset = outputs[1][parityIndex].arrayOffset() + outputs[1][parityIndex].position();
                for (int j = 0; j < bufSize; ++j) {
                    newOut[k] = (byte)(newOut[k] ^ piggyBacks[i].get(j));
                    ++k;
                }
            }
            return;
        }
        for (int i = 0; i < numParityUnits - 1; ++i) {
            int parityIndex = i + 1;
            int k = piggyBacks[i].position();
            int m = outputs[1][parityIndex].position();
            while (k < piggyBacks[i].limit()) {
                outputs[1][parityIndex].put(m, (byte)(outputs[1][parityIndex].get(m) ^ piggyBacks[i].get(k)));
                ++k;
                ++m;
            }
        }
    }
}

