/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch() {
        this(0);
    }

    public CountUpDownLatch(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(n);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
    }

    public void countUp() {
        this.sync.releaseShared(this.sync.getCount() + 1);
    }

    public void countDown() {
        this.sync.releaseShared(this.sync.getCount() - 1);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public void setCount(int n) {
        this.sync.releaseShared(n);
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        Sync(int n) {
            this.setState(n);
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int n) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int n) {
            boolean bl;
            int n2 = Math.max(0, n);
            boolean bl2 = bl = n2 == 0;
            while (!this.compareAndSetState(this.getState(), n2)) {
            }
            return bl;
        }
    }
}

