/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;

public class MultiFilingServiceImpl
extends AbstractBrowserBindingService
implements MultiFilingService {
    public MultiFilingServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("addObjectToFolder");
        formData.addParameter("folderId", folderId);
        formData.addParameter("allVersions", allVersions);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("removeObjectFromFolder");
        formData.addParameter("folderId", folderId);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }
}

