/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;

public class QueryResultImpl
implements QueryResult,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, PropertyData<?>> propertiesById = new LinkedHashMap();
    private Map<String, PropertyData<?>> propertiesByQueryName = new LinkedHashMap();
    private AllowableActions allowableActions;
    private List<Relationship> relationships;
    private List<Rendition> renditions;

    public QueryResultImpl(Session session, ObjectData objectData) {
        if (objectData != null) {
            ObjectFactory of = session.getObjectFactory();
            if (objectData.getProperties() != null) {
                List queryProperties = of.convertQueryProperties(objectData.getProperties());
                for (PropertyData property : queryProperties) {
                    this.propertiesById.put(property.getId(), property);
                    this.propertiesByQueryName.put(property.getQueryName(), property);
                }
            }
            if (objectData.getAllowableActions() != null) {
                this.allowableActions = objectData.getAllowableActions();
            }
            if (objectData.getRelationships() != null) {
                this.relationships = new ArrayList<Relationship>();
                for (ObjectData rod : objectData.getRelationships()) {
                    CmisObject relationship = of.convertObject(rod, session.getDefaultContext());
                    if (!(relationship instanceof Relationship)) continue;
                    this.relationships.add((Relationship)relationship);
                }
            }
            if (objectData.getRenditions() != null) {
                this.renditions = new ArrayList<Rendition>();
                for (RenditionData rd : objectData.getRenditions()) {
                    this.renditions.add(of.convertRendition(null, rd));
                }
            }
        }
    }

    public List<PropertyData<?>> getProperties() {
        return new ArrayList(this.propertiesByQueryName.values());
    }

    public <T> PropertyData<T> getPropertyById(String id) {
        return this.propertiesById.get(id);
    }

    public <T> PropertyData<T> getPropertyByQueryName(String queryName) {
        return this.propertiesByQueryName.get(queryName);
    }

    public <T> T getPropertyValueById(String id) {
        PropertyData<T> property = this.getPropertyById(id);
        if (property == null) {
            return null;
        }
        return (T)property.getFirstValue();
    }

    public <T> T getPropertyValueByQueryName(String queryName) {
        PropertyData<T> property = this.getPropertyByQueryName(queryName);
        if (property == null) {
            return null;
        }
        return (T)property.getFirstValue();
    }

    public <T> List<T> getPropertyMultivalueById(String id) {
        PropertyData<T> property = this.getPropertyById(id);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    public <T> List<T> getPropertyMultivalueByQueryName(String queryName) {
        PropertyData<T> property = this.getPropertyByQueryName(queryName);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    public AllowableActions getAllowableActions() {
        return this.allowableActions;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<Rendition> getRenditions() {
        return this.renditions;
    }
}

