/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeListUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeRestrictionUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnionUnmarshaller;

public class SimpleTypeUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private SimpleTypeDefinition _simpleTypeDef = null;
    private SimpleType _simpleType = null;
    private boolean foundAnnotation = false;
    private boolean foundList = false;
    private boolean foundRestriction = false;
    private boolean foundUnion = false;

    public SimpleTypeUnmarshaller(Schema schema, AttributeSet atts) throws XMLException {
        String prefix;
        String ns;
        int idx;
        String name = atts.getValue("name");
        if (name != null && (idx = name.indexOf(58)) >= 0 && (ns = schema.getNamespace(prefix = name.substring(0, idx))) != null && ns.equals(schema.getTargetNamespace())) {
            name = name.substring(idx + 1);
        }
        String id = atts.getValue("id");
        this._simpleTypeDef = new SimpleTypeDefinition(schema, name, id);
        this._simpleTypeDef.setFinal(atts.getValue("final"));
    }

    public String elementName() {
        return "simpleType";
    }

    public SimpleType getSimpleType() {
        if (this._simpleType == null) {
            this._simpleType = this._simpleTypeDef.createSimpleType();
        }
        return this._simpleType;
    }

    public Object getObject() {
        return this.getSimpleType();
    }

    public void finish() throws XMLException {
        if (!(this.foundList || this.foundUnion || this.foundRestriction)) {
            this.error("Invalid 'simpleType'; missing 'restriction' | 'union' | 'list'.");
        }
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'simpleType'.");
            }
            if (this.foundList || this.foundUnion || this.foundRestriction) {
                this.error("An annotation may only appear as the first child of 'simpleType'.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else if ("restriction".equals(name)) {
            if (this.foundList) {
                this.error("A 'simpleType' cannot have both a 'list' and a 'restriction' in the same definition.");
            }
            if (this.foundUnion) {
                this.error("A 'simpleType' cannot have both a 'union' and a 'restriction' in the same definition.");
            }
            this.foundRestriction = true;
            this.unmarshaller = new SimpleTypeRestrictionUnmarshaller(this._simpleTypeDef, atts);
        } else if ("list".equals(name)) {
            this.foundList = true;
            Schema schema = this._simpleTypeDef.getSchema();
            this.unmarshaller = new SimpleTypeListUnmarshaller(schema, atts);
        } else if ("union".equals(name)) {
            this.foundUnion = true;
            Schema schema = this._simpleTypeDef.getSchema();
            this.unmarshaller = new UnionUnmarshaller(schema, atts);
        } else {
            this.illegalElement(name);
        }
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._simpleTypeDef.setAnnotation(annotation);
        } else if ("list".equals(name)) {
            this._simpleType = (SimpleType)this.unmarshaller.getObject();
            this._simpleTypeDef.copyInto(this._simpleType);
        } else if ("union".equals(name)) {
            this._simpleType = (SimpleType)this.unmarshaller.getObject();
            this._simpleTypeDef.copyInto(this._simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

