/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.Event;
import org.apache.fop.util.XMLResourceBundle;
import org.apache.fop.util.text.AdvancedMessageFormat;

public final class EventFormatter {
    private static final Pattern INCLUDES_PATTERN = Pattern.compile("\\{\\{.+\\}\\}");
    private static Log log = LogFactory.getLog((Class)EventFormatter.class);

    private EventFormatter() {
    }

    public static String format(Event event) {
        ResourceBundle bundle = null;
        String groupID = event.getEventGroupID();
        if (groupID != null) {
            try {
                bundle = XMLResourceBundle.getXMLBundle(groupID, EventFormatter.class.getClassLoader());
            }
            catch (MissingResourceException mre) {
                throw new IllegalStateException("No XMLResourceBundle for " + groupID + " available.");
            }
        }
        return EventFormatter.format(event, bundle);
    }

    public static String format(Event event, Locale locale) {
        ResourceBundle bundle;
        block4: {
            bundle = null;
            String groupID = event.getEventGroupID();
            if (groupID != null) {
                try {
                    bundle = XMLResourceBundle.getXMLBundle(groupID, locale, EventFormatter.class.getClassLoader());
                }
                catch (MissingResourceException mre) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("No XMLResourceBundle for " + groupID + " available."));
                }
            }
        }
        if (bundle == null) {
            bundle = XMLResourceBundle.getXMLBundle(EventFormatter.class.getName(), locale, EventFormatter.class.getClassLoader());
        }
        return EventFormatter.format(event, bundle);
    }

    private static String format(Event event, ResourceBundle bundle) {
        String template = bundle.getString(event.getEventKey());
        return EventFormatter.format(event, EventFormatter.processIncludes(template, bundle));
    }

    private static String processIncludes(String template, ResourceBundle bundle) {
        StringBuffer sb;
        int replacements;
        CharSequence input = template;
        do {
            sb = new StringBuffer(Math.max(16, input.length()));
            replacements = EventFormatter.processIncludesInner(input, sb, bundle);
            input = sb;
        } while (replacements > 0);
        String s = sb.toString();
        return s;
    }

    private static int processIncludesInner(CharSequence template, StringBuffer sb, ResourceBundle bundle) {
        int replacements = 0;
        Matcher m = INCLUDES_PATTERN.matcher(template);
        while (m.find()) {
            String include = m.group();
            include = include.substring(2, include.length() - 2);
            m.appendReplacement(sb, bundle.getString(include));
            ++replacements;
        }
        m.appendTail(sb);
        return replacements;
    }

    public static String format(Event event, String pattern) {
        AdvancedMessageFormat format = new AdvancedMessageFormat(pattern);
        HashMap<String, Object> params = new HashMap<String, Object>(event.getParams());
        params.put("source", event.getSource());
        params.put("severity", event.getSeverity());
        return format.format(params);
    }

    public static class LookupFieldPartFactory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String fieldName, String values) {
            return new LookupFieldPart(fieldName);
        }

        public String getFormat() {
            return "lookup";
        }
    }

    private static class LookupFieldPart
    implements AdvancedMessageFormat.Part {
        private String fieldName;

        public LookupFieldPart(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean isGenerated(Map params) {
            return this.getKey(params) != null;
        }

        public void write(StringBuffer sb, Map params) {
        }

        private String getKey(Map params) {
            return (String)params.get(this.fieldName);
        }

        public String toString() {
            return "{" + this.fieldName + ", lookup}";
        }
    }
}

