/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementQuery;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    StatementResultUpdate() {
        this.writeTableNames = new HsqlNameManager.HsqlName[1];
        this.setCompileTimestamp(Long.MAX_VALUE);
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable throwable) {
            this.clearStructures(session);
            result = Result.newErrorResult(throwable, null);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        this.checkAccessRights(session);
        Object[] objectArray = session.sessionContext.dynamicArguments;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        switch (this.actionType) {
            case 81: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] blArray = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    objectArray2[this.baseColumnMap[i]] = objectArray[i];
                    blArray[this.baseColumnMap[i]] = true;
                }
                int[] nArray = ArrayUtil.booleanArrayToIntIndexes(blArray);
                rowSetNavigatorDataChange.addRow(session, row, objectArray2, this.baseTable.getColumnTypes(), nArray);
                rowSetNavigatorDataChange.endMainDataSet();
                this.update(session, this.baseTable, rowSetNavigatorDataChange, null);
                break;
            }
            case 18: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
                rowSetNavigatorDataChange.addRow(row);
                rowSetNavigatorDataChange.endMainDataSet();
                this.delete(session, this.baseTable, rowSetNavigatorDataChange);
                break;
            }
            case 50: {
                Object[] objectArray3 = this.baseTable.getNewRowData(session);
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    objectArray3[this.baseColumnMap[i]] = objectArray[i];
                }
                return this.insertSingleRow(session, persistentStore, objectArray3);
            }
        }
        return Result.updateOneResult;
    }

    Row getRow(Session session, Object[] objectArray) {
        int n = this.result.metaData.getColumnCount();
        Long l = (Long)objectArray[n];
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        Row row = null;
        if (n + 2 == this.result.metaData.getExtendedColumnCount()) {
            Object[] objectArray2 = ((RowSetNavigatorData)this.result.getNavigator()).getData(l);
            if (objectArray2 != null) {
                row = (Row)objectArray2[n + 1];
            }
        } else {
            int n2 = (int)l.longValue();
            row = (Row)persistentStore.get(n2, false);
        }
        this.result = null;
        return row;
    }

    void setRowActionProperties(Result result, int n, StatementQuery statementQuery, Type[] typeArray) {
        QueryExpression queryExpression = statementQuery.queryExpression;
        this.result = result;
        this.actionType = n;
        this.baseTable = queryExpression.getBaseTable();
        this.types = typeArray;
        this.baseColumnMap = queryExpression.getBaseTableColumnMap();
        this.writeTableNames[0] = this.baseTable.getName();
        this.sql = statementQuery.getSQL();
        this.parameterMetaData = queryExpression.getMetaData();
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

