/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ObliqueStereographic
extends NormalizedProjection {
    private static final long serialVersionUID = -1725537881127730658L;
    final double \u03c70;
    final double sin\u03c70;
    final double cos\u03c70;
    private final double c;
    private final double n;
    private final double g;
    private final double h;
    private final double \u03b8_bound;

    public ObliqueStereographic(OperationMethod operationMethod, Parameters parameters) {
        this(ObliqueStereographic.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, Object> enumMap = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.ObliqueStereographic.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.ObliqueStereographic.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.ObliqueStereographic.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.ObliqueStereographic.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, 0);
    }

    private ObliqueStereographic(Initializer initializer) {
        super(initializer);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.ObliqueStereographic.LATITUDE_OF_ORIGIN));
        double d2 = Math.sin(d);
        double d3 = this.eccentricity * d2;
        this.n = Math.sqrt(1.0 + this.eccentricitySquared * Math.pow(Math.cos(d), 4.0) / (1.0 - this.eccentricitySquared));
        double d4 = (1.0 + d2) / (1.0 - d2);
        double d5 = (1.0 - d3) / (1.0 + d3);
        double d6 = Math.pow(d4 * Math.pow(d5, this.eccentricity), this.n);
        double d7 = (d6 - 1.0) / (d6 + 1.0);
        this.c = (this.n + d2) * (1.0 - d7) / ((this.n - d2) * (1.0 + d7));
        double d8 = this.c * d6;
        this.sin\u03c70 = (d8 - 1.0) / (d8 + 1.0);
        this.\u03c70 = Math.asin(this.sin\u03c70);
        this.cos\u03c70 = Math.cos(this.\u03c70);
        this.g = Math.tan(0.7853981633974483 - this.\u03c70 / 2.0);
        this.h = 2.0 * Math.tan(this.\u03c70) + this.g;
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertAfter(0, this.n, null);
        double d9 = 2.0 * initializer.radiusOfConformalSphere(d2);
        matrixSIS2.convertBefore(0, d9, null);
        matrixSIS2.convertBefore(1, d9, null);
        this.\u03b8_bound = initializer.boundOfScaledLongitude(this.n);
    }

    ObliqueStereographic(ObliqueStereographic obliqueStereographic) {
        super(obliqueStereographic);
        this.\u03c70 = obliqueStereographic.\u03c70;
        this.sin\u03c70 = obliqueStereographic.sin\u03c70;
        this.cos\u03c70 = obliqueStereographic.cos\u03c70;
        this.c = obliqueStereographic.c;
        this.n = obliqueStereographic.n;
        this.g = obliqueStereographic.g;
        this.h = obliqueStereographic.h;
        this.\u03b8_bound = obliqueStereographic.\u03b8_bound;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c7\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.\u03c70};
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        Serializable serializable;
        if (Double.isNaN(this.\u03c70) && (serializable = this.context.getValue(org.apache.sis.internal.referencing.provider.ObliqueStereographic.LATITUDE_OF_ORIGIN)) != null && Math.abs(Math.abs((Double)serializable) - 90.0) < 8.999280057595393E-8) {
            return this.delegate(mathTransformFactory, "Polar Stereographic (variant A)");
        }
        serializable = this;
        if (this.eccentricity == 0.0) {
            serializable = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, (MathTransform)serializable);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = ObliqueStereographic.wraparoundScaledLongitude(dArray[n], this.\u03b8_bound);
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = this.eccentricity * d3;
        double d5 = (1.0 + d3) / (1.0 - d3);
        double d6 = (1.0 - d4) / (1.0 + d4);
        double d7 = this.c * Math.pow(d5 * Math.pow(d6, this.eccentricity), this.n);
        double d8 = (d7 - 1.0) / (d7 + 1.0);
        double d9 = Math.sqrt(1.0 - d8 * d8);
        double d10 = Math.cos(d);
        double d11 = Math.sin(d);
        double d12 = d8 * this.sin\u03c70;
        double d13 = d9 * this.cos\u03c70;
        double d14 = 1.0 + d12 + d13 * d10;
        if (dArray2 != null) {
            dArray2[n2] = d9 * d11 / d14;
            dArray2[n2 + 1] = (d8 * this.cos\u03c70 - d9 * this.sin\u03c70 * d10) / d14;
        }
        if (!bl) {
            return null;
        }
        double d15 = Math.cos(d2);
        double d16 = (1.0 / d15 - d15 * this.eccentricitySquared / (1.0 - d4 * d4)) * 2.0 * this.n * Math.sqrt(d7) / (d7 + 1.0);
        double d17 = d14 * d14;
        double d18 = (d13 + d10 * (d12 + 1.0)) / d17;
        double d19 = d11 * (d8 + this.sin\u03c70) / d17;
        return new Matrix2(d18 * d9, -d19 * d16, d19 * d9, d18 * d16);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.atan(d / (this.h + d2));
        double d4 = Math.atan(d / (this.g - d2)) - d3;
        double d5 = d4 + 2.0 * d3;
        double d6 = Math.sin(this.\u03c70 + 2.0 * Math.atan(d2 - d * Math.tan(d4 / 2.0)));
        double d7 = Math.log((1.0 + d6) / ((1.0 - d6) * this.c)) / (2.0 * this.n);
        double d8 = 2.0 * Math.atan(Math.exp(d7)) - 1.5707963267948966;
        double d9 = this.eccentricity / 2.0;
        double d10 = 1.0 - this.eccentricitySquared;
        for (int i = 0; i < 18; ++i) {
            double d11 = this.eccentricity * Math.sin(d8);
            double d12 = Math.log(Math.tan(d8 / 2.0 + 0.7853981633974483) * Math.pow((1.0 - d11) / (1.0 + d11), d9));
            double d13 = (d7 - d12) * Math.cos(d8) * (1.0 - d11 * d11) / d10;
            d8 += d13;
            if (Math.abs(d13) > 3.926676682852614E-10) continue;
            dArray2[n2] = d5;
            dArray2[n2 + 1] = d8;
            return;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    static final class Spherical
    extends ObliqueStereographic {
        private static final long serialVersionUID = -1454098847621943639L;

        protected Spherical(ObliqueStereographic obliqueStereographic) {
            super(obliqueStereographic);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d);
            double d6 = Math.cos(d);
            double d7 = d3 * this.sin\u03c70;
            double d8 = d4 * this.cos\u03c70;
            double d9 = d4 * d5;
            double d10 = 1.0 + d7 + d8 * d6;
            if (dArray2 != null) {
                dArray2[n2] = d9 / d10;
                dArray2[n2 + 1] = (d3 * this.cos\u03c70 - d4 * this.sin\u03c70 * d6) / d10;
            }
            if (!bl) {
                return null;
            }
            double d11 = d10 * d10;
            double d12 = (d8 + d6 * (d7 + 1.0)) / d11;
            double d13 = d5 * (d3 + this.sin\u03c70) / d11;
            return new Matrix2(d12 * d4, -d13, d13 * d4, d12);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d;
            double d2;
            double d3 = dArray[n];
            double d4 = dArray[n + 1];
            double d5 = Spherical.fastHypot(d3, d4);
            if (d5 == 0.0) {
                d2 = 0.0;
                d = this.\u03c70;
            } else {
                double d6 = 2.0 * Math.atan(d5);
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                d2 = Math.atan2(d3 * d8, d7 * this.cos\u03c70 * d5 - d4 * d8 * this.sin\u03c70);
                d = Math.asin(d7 * this.sin\u03c70 + d4 * d8 * this.cos\u03c70 / d5);
            }
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d;
        }
    }
}

