/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class Node {
    private String id;
    private List<Metric> metrics;
    private Set<String> ancestors;

    public Node(String id, boolean track) {
        this.id = id;
        if (track) {
            this.ancestors = new HashSet<String>();
        }
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public void add(String ancestor, Tuple tuple) {
        if (this.ancestors != null) {
            this.ancestors.add(ancestor);
        }
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                metric.update(tuple);
            }
        }
    }

    public Tuple toTuple(String collection, String field, int level, Traversal traversal) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("node", this.id);
        map.put("collection", collection);
        map.put("field", field);
        map.put("level", level);
        boolean prependCollection = traversal.isMultiCollection();
        List<String> cols = traversal.getCollections();
        if (this.ancestors != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String ancestor : this.ancestors) {
                String[] ancestorParts = ancestor.split("\\^");
                if (prependCollection) {
                    int colIndex = Integer.parseInt(ancestorParts[0]);
                    l.add(cols.get(colIndex) + "/" + ancestorParts[1]);
                    continue;
                }
                l.add(ancestorParts[1]);
            }
            map.put("ancestors", l);
        }
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                map.put(metric.getIdentifier(), metric.getValue());
            }
        }
        return new Tuple(map);
    }
}

