/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected String subjectIP = null;
    protected String subjectDNS = null;
    protected String authMethod = null;
    protected Date authInstant = null;
    protected ArrayList bindings = new ArrayList();
    public static final String AuthenticationMethod_Password = "urn:oasis:names:tc:SAML:1.0:am:password";
    public static final String AuthenticationMethod_Kerberos = "urn:ietf:rfc:1510";
    public static final String AuthenticationMethod_SRP = "urn:ietf:rfc:2945";
    public static final String AuthenticationMethod_HardwareToken = "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
    public static final String AuthenticationMethod_SSL_TLS_Client = "urn:ietf:rfc:2246";
    public static final String AuthenticationMethod_X509_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    public static final String AuthenticationMethod_PGP_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:PGP";
    public static final String AuthenticationMethod_SPKI_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:SPKI";
    public static final String AuthenticationMethod_XKMS_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:XKMS";
    public static final String AuthenticationMethod_XML_DSig = "urn:ietf:rfc:3075";
    public static final String AuthenticationMethod_Unspecified = "urn:oasis:names:tc:SAML:1.0:am:unspecified";

    public SAMLAuthenticationStatement() {
    }

    public SAMLAuthenticationStatement(SAMLSubject sAMLSubject, String string, Date date, String string2, String string3, Collection collection) throws SAMLException {
        super(sAMLSubject);
        this.subjectIP = XML.assign(string2);
        this.subjectDNS = XML.assign(string3);
        this.authMethod = XML.assign(string);
        this.authInstant = date;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.bindings.add(((SAMLAuthorityBinding)iterator.next()).setParent(this));
            }
        }
    }

    public SAMLAuthenticationStatement(SAMLSubject sAMLSubject, Date date, String string, String string2, Collection collection) throws SAMLException {
        this(sAMLSubject, AuthenticationMethod_Unspecified, date, string, string2, collection);
    }

    public SAMLAuthenticationStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthenticationStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthenticationStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement")) {
            object = XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AuthenticationStatementType".equals(((QName)object).getLocalPart()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires saml:AuthenticationStatement at root");
            }
        }
        this.authMethod = XML.assign(element.getAttributeNS(null, "AuthenticationMethod"));
        try {
            object = null;
            String string = XML.assign(element.getAttributeNS(null, "AuthenticationInstant"));
            int n = string.indexOf(46);
            object = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            this.authInstant = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() detected an invalid datetime while parsing statement", (Exception)parseException);
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
        if (object != null) {
            this.subjectIP = XML.assign(object.getAttributeNS(null, "IPAddress"));
            this.subjectDNS = XML.assign(object.getAttributeNS(null, "DNSAddress"));
            object = XML.getNextSiblingElement((Node)object);
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        while (object != null) {
            this.bindings.add(new SAMLAuthorityBinding((Element)object).setParent(this));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        }
        this.checkValidity();
    }

    public String getSubjectIP() {
        return this.subjectIP;
    }

    public void setSubjectIP(String string) {
        this.subjectIP = XML.assign(string);
        this.setDirty(true);
    }

    public String getSubjectDNS() {
        return this.subjectDNS;
    }

    public void setSubjectDNS(String string) {
        this.subjectDNS = XML.assign(string);
        this.setDirty(true);
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("authMethod cannot be null");
        }
        this.authMethod = string;
        this.setDirty(true);
    }

    public Date getAuthInstant() {
        return this.authInstant;
    }

    public void setAuthInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("authInstant cannot be null");
        }
        this.authInstant = date;
        this.setDirty(true);
    }

    public Iterator getBindings() {
        return this.bindings.iterator();
    }

    public void setBindings(Collection collection) throws SAMLException {
        this.bindings.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.bindings.add(((SAMLAuthorityBinding)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addBinding(SAMLAuthorityBinding sAMLAuthorityBinding) throws SAMLException {
        if (sAMLAuthorityBinding == null) {
            throw new IllegalArgumentException("binding cannot be null");
        }
        this.bindings.add(sAMLAuthorityBinding.setParent(this));
        this.setDirty(true);
    }

    public void removeBinding(int n) {
        this.bindings.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            Object object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            element.setAttributeNS(null, "AuthenticationInstant", simpleDateFormat.format(this.authInstant));
            element.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
            if (!XML.isEmpty(this.subjectIP) || !XML.isEmpty(this.subjectDNS)) {
                object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
                if (!XML.isEmpty(this.subjectIP)) {
                    object.setAttributeNS(null, "IPAddress", this.subjectIP);
                }
                if (!XML.isEmpty(this.subjectDNS)) {
                    object.setAttributeNS(null, "DNSAddress", this.subjectDNS);
                }
                element.appendChild((Node)object);
            }
            object = this.bindings.iterator();
            while (object.hasNext()) {
                element.appendChild(((SAMLAuthorityBinding)object.next()).toDOM(document, false));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (XML.isEmpty(this.authMethod) || this.authInstant == null) {
            throw new MalformedException("AuthenticationStatement is invalid, requires AuthenticationMethod and AuthenticationInstant");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthenticationStatement sAMLAuthenticationStatement = (SAMLAuthenticationStatement)super.clone();
        try {
            sAMLAuthenticationStatement.bindings = new ArrayList();
            Iterator iterator = this.bindings.iterator();
            while (iterator.hasNext()) {
                sAMLAuthenticationStatement.bindings.add(((SAMLAuthorityBinding)((SAMLAuthorityBinding)iterator.next()).clone()).setParent(sAMLAuthenticationStatement));
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLAuthenticationStatement;
    }
}

