/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockKnuthSequence;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public abstract class AbstractBreaker {
    protected static Log log = LogFactory.getLog((Class)AbstractBreaker.class);
    private int blockListIndex = 0;
    private List blockLists = null;
    protected int alignment;
    private int alignmentLast;
    protected MinOptMax footnoteSeparatorLength = MinOptMax.ZERO;

    static String getBreakClassName(int breakClassId) {
        switch (breakClassId) {
            case 5: {
                return "ALL";
            }
            case 8: {
                return "ANY";
            }
            case 9: {
                return "AUTO";
            }
            case 28: {
                return "COLUMN";
            }
            case 44: {
                return "EVEN PAGE";
            }
            case 75: {
                return "LINE";
            }
            case 95: {
                return "NONE";
            }
            case 100: {
                return "ODD PAGE";
            }
            case 104: {
                return "PAGE";
            }
        }
        return "??? (" + String.valueOf(breakClassId) + ")";
    }

    protected abstract int getCurrentDisplayAlign();

    protected abstract boolean hasMoreContent();

    protected abstract void addAreas(PositionIterator var1, LayoutContext var2);

    protected abstract LayoutManager getTopLevelLM();

    protected abstract LayoutManager getCurrentChildLM();

    protected boolean isPartOverflowRecoveryActivated() {
        return true;
    }

    protected boolean isSinglePartFavored() {
        return false;
    }

    protected PageProvider getPageProvider() {
        return null;
    }

    protected PageBreakingAlgorithm.PageBreakingLayoutListener createLayoutListener() {
        return null;
    }

    protected abstract List getNextKnuthElements(LayoutContext var1, int var2);

    protected List getNextKnuthElements(LayoutContext context, int alignment, Position positionAtIPDChange, LayoutManager restartAtLM) {
        throw new UnsupportedOperationException("TODO: implement acceptable fallback");
    }

    public boolean isEmpty() {
        return this.blockLists.isEmpty();
    }

    protected void startPart(BlockSequence list, int breakClass) {
    }

    protected void handleEmptyContent() {
    }

    protected abstract void finishPart(PageBreakingAlgorithm var1, PageBreakPosition var2);

    protected LayoutContext createLayoutContext() {
        return new LayoutContext(0);
    }

    protected void updateLayoutContext(LayoutContext context) {
    }

    protected void observeElementList(List elementList) {
        ElementListObserver.observe(elementList, "breaker", null);
    }

    public void doLayout(int flowBPD, boolean autoHeight) {
        LayoutContext childLC = this.createLayoutContext();
        childLC.setStackLimitBP(MinOptMax.getInstance(flowBPD));
        this.alignment = this.getCurrentDisplayAlign() == 162 ? 70 : (this.getCurrentDisplayAlign() == 163 ? 70 : 135);
        this.alignmentLast = 135;
        if (this.isSinglePartFavored() && this.alignment == 70) {
            this.alignmentLast = 70;
        }
        childLC.setBPAlignment(this.alignment);
        this.blockLists = new ArrayList();
        log.debug((Object)("PLM> flow BPD =" + flowBPD));
        int nextSequenceStartsOn = 8;
        while (this.hasMoreContent()) {
            this.blockLists.clear();
            nextSequenceStartsOn = this.getNextBlockList(childLC, nextSequenceStartsOn);
            log.debug((Object)("PLM> blockLists.size() = " + this.blockLists.size()));
            this.blockListIndex = 0;
            while (this.blockListIndex < this.blockLists.size()) {
                BlockSequence blockList = (BlockSequence)this.blockLists.get(this.blockListIndex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  blockListIndex = " + this.blockListIndex));
                    log.debug((Object)("  sequence starts on " + AbstractBreaker.getBreakClassName(blockList.startOn)));
                }
                this.observeElementList(blockList);
                log.debug((Object)("PLM> start of algorithm (" + this.getClass().getName() + "), flow BPD =" + flowBPD));
                PageBreakingAlgorithm alg = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), this.alignment, this.alignmentLast, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), autoHeight, this.isSinglePartFavored());
                BlockSequence effectiveList = this.getCurrentDisplayAlign() == 162 ? this.justifyBoxes(blockList, alg, flowBPD) : blockList;
                alg.setConstantLineWidth(flowBPD);
                int optimalPageCount = alg.findBreakingPoints(effectiveList, 1.0, true, 0);
                if (alg.getIPDdifference() != 0) {
                    ListIterator iter;
                    BreakingAlgorithm.KnuthNode optimalBreak = alg.getBestNodeBeforeIPDChange();
                    int positionIndex = optimalBreak.position;
                    KnuthElement elementAtBreak = alg.getElement(positionIndex);
                    Position positionAtBreak = elementAtBreak.getPosition();
                    if (!(positionAtBreak instanceof SpaceResolver.SpaceHandlingBreakPosition)) {
                        throw new UnsupportedOperationException("Don't know how to restart at position" + positionAtBreak);
                    }
                    positionAtBreak = positionAtBreak.getPosition();
                    LayoutManager restartAtLM = null;
                    LinkedList<KnuthElement> firstElements = Collections.EMPTY_LIST;
                    if (this.containsNonRestartableLM(positionAtBreak)) {
                        if (alg.getIPDdifference() > 0) {
                            EventBroadcaster eventBroadcaster = this.getCurrentChildLM().getFObj().getUserAgent().getEventBroadcaster();
                            BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(eventBroadcaster);
                            eventProducer.nonRestartableContentFlowingToNarrowerPage(this);
                        }
                        firstElements = new LinkedList<KnuthElement>();
                        boolean boxFound = false;
                        iter = effectiveList.listIterator(positionIndex + 1);
                        Position position = null;
                        while (iter.hasNext() && (position == null || this.containsNonRestartableLM(position))) {
                            ++positionIndex;
                            KnuthElement element = (KnuthElement)iter.next();
                            position = element.getPosition();
                            if (element.isBox()) {
                                boxFound = true;
                                firstElements.add(element);
                                continue;
                            }
                            if (!boxFound) continue;
                            firstElements.add(element);
                        }
                        positionAtBreak = position instanceof SpaceResolver.SpaceHandlingBreakPosition ? position.getPosition() : null;
                    }
                    if (positionAtBreak != null && positionAtBreak.getIndex() == -1) {
                        KnuthElement nextElement;
                        Position position;
                        iter = effectiveList.listIterator(positionIndex + 1);
                        while ((position = (nextElement = (KnuthElement)iter.next()).getPosition()) == null || position instanceof SpaceResolver.SpaceHandlingPosition || position instanceof SpaceResolver.SpaceHandlingBreakPosition && position.getPosition().getIndex() == -1) {
                        }
                        LayoutManager surroundingLM = positionAtBreak.getLM();
                        while (position.getLM() != surroundingLM) {
                            position = position.getPosition();
                        }
                        restartAtLM = position.getPosition().getLM();
                    }
                    log.trace((Object)("IPD changes after page " + optimalPageCount + " at index " + optimalBreak.position));
                    this.addAreas(alg, optimalPageCount, blockList, effectiveList);
                    this.blockLists.clear();
                    this.blockListIndex = -1;
                    nextSequenceStartsOn = this.getNextBlockList(childLC, 28, positionAtBreak, restartAtLM, firstElements);
                } else {
                    log.debug((Object)("PLM> iOptPageCount= " + optimalPageCount + " pageBreaks.size()= " + alg.getPageBreaks().size()));
                    this.doPhase3(alg, optimalPageCount, blockList, effectiveList);
                }
                ++this.blockListIndex;
            }
        }
    }

    private boolean containsNonRestartableLM(Position position) {
        LayoutManager lm = position.getLM();
        if (lm != null && !lm.isRestartable()) {
            return true;
        }
        Position subPosition = position.getPosition();
        if (subPosition == null) {
            return false;
        }
        return this.containsNonRestartableLM(subPosition);
    }

    protected abstract void doPhase3(PageBreakingAlgorithm var1, int var2, BlockSequence var3, BlockSequence var4);

    protected void addAreas(PageBreakingAlgorithm alg, int partCount, BlockSequence originalList, BlockSequence effectiveList) {
        this.addAreas(alg, 0, partCount, originalList, effectiveList);
    }

    protected void addAreas(PageBreakingAlgorithm alg, int startPart, int partCount, BlockSequence originalList, BlockSequence effectiveList) {
        ListIterator effectiveListIterator = effectiveList.listIterator();
        int startElementIndex = 0;
        int endElementIndex = 0;
        int lastBreak = -1;
        for (int p = startPart; p < startPart + partCount; ++p) {
            int lastBreakClass;
            PageBreakPosition pbp = (PageBreakPosition)alg.getPageBreaks().get(p);
            if (p == 0) {
                lastBreakClass = effectiveList.getStartOn();
            } else {
                ListElement lastBreakElement = effectiveList.getElement(endElementIndex);
                if (lastBreakElement.isPenalty()) {
                    KnuthPenalty pen = (KnuthPenalty)lastBreakElement;
                    lastBreakClass = pen.getBreakClass();
                } else {
                    lastBreakClass = 28;
                }
            }
            endElementIndex = pbp.getLeafPos();
            log.debug((Object)("PLM> part: " + (p + 1) + ", start at pos " + (startElementIndex += startElementIndex == 0 ? effectiveList.ignoreAtStart : 0) + ", break at pos " + endElementIndex + ", break class = " + AbstractBreaker.getBreakClassName(lastBreakClass)));
            this.startPart(effectiveList, lastBreakClass);
            int displayAlign = this.getCurrentDisplayAlign();
            int notificationEndElementIndex = endElementIndex;
            if (((KnuthElement)effectiveList.get(endElementIndex -= endElementIndex == originalList.size() - 1 ? effectiveList.ignoreAtEnd : 0)).isGlue()) {
                --endElementIndex;
            }
            effectiveListIterator = effectiveList.listIterator(startElementIndex);
            while (effectiveListIterator.hasNext() && !((KnuthElement)effectiveListIterator.next()).isBox()) {
                ++startElementIndex;
            }
            if (startElementIndex <= endElementIndex) {
                int averageLineLength;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("     addAreas from " + startElementIndex + " to " + endElementIndex));
                }
                LayoutContext childLC = new LayoutContext(0);
                childLC.setSpaceAdjust(pbp.bpdAdjust);
                if (pbp.difference != 0 && displayAlign == 23) {
                    childLC.setSpaceBefore(pbp.difference / 2);
                } else if (pbp.difference != 0 && displayAlign == 3) {
                    childLC.setSpaceBefore(pbp.difference);
                } else if (pbp.difference != 0 && displayAlign == 163 && p < partCount - 1) {
                    int boxCount = 0;
                    effectiveListIterator = effectiveList.listIterator(startElementIndex);
                    while (effectiveListIterator.nextIndex() <= endElementIndex) {
                        KnuthElement tempEl = (KnuthElement)effectiveListIterator.next();
                        if (!tempEl.isBox() || tempEl.getWidth() <= 0) continue;
                        ++boxCount;
                    }
                    if (boxCount >= 2) {
                        childLC.setSpaceAfter(pbp.difference / (boxCount - 1));
                    }
                }
                if (displayAlign == 162 && (averageLineLength = this.optimizeLineLength(effectiveList, startElementIndex, endElementIndex)) != 0) {
                    childLC.setStackLimitBP(MinOptMax.getInstance(averageLineLength));
                }
                SpaceResolver.performConditionalsNotification(effectiveList, startElementIndex, notificationEndElementIndex, lastBreak);
                this.addAreas(new KnuthPossPosIter(effectiveList, startElementIndex, endElementIndex + 1), childLC);
            } else {
                this.handleEmptyContent();
            }
            this.finishPart(alg, pbp);
            lastBreak = endElementIndex;
            startElementIndex = pbp.getLeafPos() + 1;
        }
    }

    protected int handleSpanChange(LayoutContext childLC, int nextSequenceStartsOn) {
        return nextSequenceStartsOn;
    }

    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn) {
        return this.getNextBlockList(childLC, nextSequenceStartsOn, null, null, null);
    }

    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn, Position positionAtIPDChange, LayoutManager restartAtLM, List firstElements) {
        List returnedList;
        this.updateLayoutContext(childLC);
        childLC.signalSpanChange(0);
        if (firstElements == null) {
            returnedList = this.getNextKnuthElements(childLC, this.alignment);
        } else if (positionAtIPDChange == null) {
            returnedList = firstElements;
            ListIterator iter = returnedList.listIterator(returnedList.size());
            for (int i = 0; i < 3; ++i) {
                iter.previous();
                iter.remove();
            }
        } else {
            returnedList = this.getNextKnuthElements(childLC, this.alignment, positionAtIPDChange, restartAtLM);
            returnedList.addAll(0, firstElements);
        }
        if (returnedList != null) {
            if (returnedList.isEmpty()) {
                nextSequenceStartsOn = this.handleSpanChange(childLC, nextSequenceStartsOn);
                return nextSequenceStartsOn;
            }
            BlockSequence blockList = new BlockSequence(nextSequenceStartsOn, this.getCurrentDisplayAlign());
            nextSequenceStartsOn = this.handleSpanChange(childLC, nextSequenceStartsOn);
            Position breakPosition = null;
            if (ElementListUtils.endsWithForcedBreak(returnedList)) {
                KnuthPenalty breakPenalty = (KnuthPenalty)ListUtil.removeLast(returnedList);
                breakPosition = breakPenalty.getPosition();
                log.debug((Object)("PLM> break - " + AbstractBreaker.getBreakClassName(breakPenalty.getBreakClass())));
                switch (breakPenalty.getBreakClass()) {
                    case 104: {
                        nextSequenceStartsOn = 8;
                        break;
                    }
                    case 28: {
                        nextSequenceStartsOn = 28;
                        break;
                    }
                    case 100: {
                        nextSequenceStartsOn = 100;
                        break;
                    }
                    case 44: {
                        nextSequenceStartsOn = 44;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid break class: " + breakPenalty.getBreakClass());
                    }
                }
            }
            blockList.addAll(returnedList);
            BlockSequence seq = blockList.endBlockSequence(breakPosition);
            if (seq != null) {
                this.blockLists.add(seq);
            }
        }
        return nextSequenceStartsOn;
    }

    private int optimizeLineLength(KnuthSequence effectiveList, int startElementIndex, int endElementIndex) {
        int boxCount = 0;
        int accumulatedLineLength = 0;
        int greatestMinimumLength = 0;
        ListIterator effectiveListIterator = effectiveList.listIterator(startElementIndex);
        while (effectiveListIterator.nextIndex() <= endElementIndex) {
            KnuthElement tempEl = (KnuthElement)effectiveListIterator.next();
            if (!(tempEl instanceof KnuthBlockBox)) continue;
            KnuthBlockBox blockBox = (KnuthBlockBox)tempEl;
            if (blockBox.getBPD() > 0) {
                log.debug((Object)("PSLM> nominal length of line = " + blockBox.getBPD()));
                log.debug((Object)("      range = " + blockBox.getIPDRange()));
                ++boxCount;
                accumulatedLineLength += ((KnuthBlockBox)tempEl).getBPD();
            }
            if (blockBox.getIPDRange().getMin() <= greatestMinimumLength) continue;
            greatestMinimumLength = blockBox.getIPDRange().getMin();
        }
        int averageLineLength = 0;
        if (accumulatedLineLength > 0 && boxCount > 0) {
            averageLineLength = accumulatedLineLength / boxCount;
            log.debug((Object)("Average line length = " + averageLineLength));
            if (averageLineLength < greatestMinimumLength) {
                averageLineLength = greatestMinimumLength;
                log.debug((Object)("  Correction to: " + averageLineLength));
            }
        }
        return averageLineLength;
    }

    private BlockSequence justifyBoxes(BlockSequence blockList, PageBreakingAlgorithm alg, int availableBPD) {
        alg.setConstantLineWidth(availableBPD);
        int iOptPageNumber = alg.findBreakingPoints(blockList, 1.0, true, 0);
        log.debug((Object)("PLM> iOptPageNumber= " + iOptPageNumber));
        ListIterator sequenceIterator = blockList.listIterator();
        ListIterator breakIterator = alg.getPageBreaks().listIterator();
        KnuthElement thisElement = null;
        while (breakIterator.hasNext()) {
            KnuthElement firstElement;
            PageBreakPosition thisBreak = (PageBreakPosition)breakIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("| first page: break= " + thisBreak.getLeafPos() + " difference= " + thisBreak.difference + " ratio= " + thisBreak.bpdAdjust));
            }
            boolean accumulatedS = false;
            int adjustedDiff = 0;
            while (!(firstElement = (KnuthElement)sequenceIterator.next()).isBox()) {
                log.debug((Object)"PLM> ignoring glue or penalty element at the beginning of the sequence");
                if (!firstElement.isGlue()) continue;
                ((BlockLevelLayoutManager)firstElement.getLayoutManager()).discardSpace((KnuthGlue)firstElement);
            }
            int firstElementIndex = sequenceIterator.previousIndex();
            sequenceIterator.previous();
            MinOptMax lineNumberMaxAdjustment = MinOptMax.ZERO;
            MinOptMax spaceMaxAdjustment = MinOptMax.ZERO;
            double spaceAdjustmentRatio = 0.0;
            LinkedList<KnuthGlue> blockSpacesList = new LinkedList<KnuthGlue>();
            LinkedList<KnuthElement> unconfirmedList = new LinkedList<KnuthElement>();
            LinkedList<KnuthElement> adjustableLinesList = new LinkedList<KnuthElement>();
            boolean bBoxSeen = false;
            while (sequenceIterator.hasNext() && sequenceIterator.nextIndex() <= thisBreak.getLeafPos()) {
                thisElement = (KnuthElement)sequenceIterator.next();
                if (thisElement.isGlue()) {
                    Adjustment adjustment = ((KnuthGlue)thisElement).getAdjustmentClass();
                    if (adjustment.equals(Adjustment.SPACE_BEFORE_ADJUSTMENT) || adjustment.equals(Adjustment.SPACE_AFTER_ADJUSTMENT)) {
                        unconfirmedList.add(thisElement);
                        continue;
                    }
                    if (adjustment.equals(Adjustment.LINE_NUMBER_ADJUSTMENT)) {
                        lineNumberMaxAdjustment = lineNumberMaxAdjustment.plusMax(thisElement.getStretch());
                        lineNumberMaxAdjustment = lineNumberMaxAdjustment.minusMin(thisElement.getShrink());
                        adjustableLinesList.add(thisElement);
                        continue;
                    }
                    if (!adjustment.equals(Adjustment.LINE_HEIGHT_ADJUSTMENT)) continue;
                }
                if (!thisElement.isBox()) continue;
                if (!bBoxSeen) {
                    bBoxSeen = true;
                    continue;
                }
                while (!unconfirmedList.isEmpty()) {
                    KnuthGlue blockSpace = (KnuthGlue)unconfirmedList.removeFirst();
                    spaceMaxAdjustment = spaceMaxAdjustment.plusMax(blockSpace.getStretch());
                    spaceMaxAdjustment = spaceMaxAdjustment.minusMin(blockSpace.getShrink());
                    blockSpacesList.add(blockSpace);
                }
            }
            log.debug((Object)("| line number adj= " + lineNumberMaxAdjustment));
            log.debug((Object)("| space adj      = " + spaceMaxAdjustment));
            if (thisElement.isPenalty() && thisElement.getWidth() > 0) {
                log.debug((Object)"  mandatory variation to the number of lines!");
                ((BlockLevelLayoutManager)thisElement.getLayoutManager()).negotiateBPDAdjustment(thisElement.getWidth(), thisElement);
            }
            if (thisBreak.bpdAdjust != 0.0 && thisBreak.difference > 0 && thisBreak.difference <= spaceMaxAdjustment.getMax() || thisBreak.difference < 0 && thisBreak.difference >= spaceMaxAdjustment.getMin()) {
                spaceAdjustmentRatio = (double)thisBreak.difference / (double)(thisBreak.difference > 0 ? spaceMaxAdjustment.getMax() : spaceMaxAdjustment.getMin());
                log.debug((Object)("single space: " + ((adjustedDiff += this.adjustBlockSpaces(blockSpacesList, thisBreak.difference, thisBreak.difference > 0 ? spaceMaxAdjustment.getMax() : -spaceMaxAdjustment.getMin())) == thisBreak.difference || thisBreak.bpdAdjust == 0.0 ? "ok" : "ERROR")));
                continue;
            }
            if (thisBreak.bpdAdjust == 0.0) continue;
            log.debug((Object)("lines and space: " + ((adjustedDiff += this.adjustBlockSpaces(blockSpacesList, thisBreak.difference - (adjustedDiff += this.adjustLineNumbers(adjustableLinesList, thisBreak.difference, thisBreak.difference > 0 ? lineNumberMaxAdjustment.getMax() : -lineNumberMaxAdjustment.getMin())), thisBreak.difference - adjustedDiff > 0 ? spaceMaxAdjustment.getMax() : -spaceMaxAdjustment.getMin())) == thisBreak.difference || thisBreak.bpdAdjust == 0.0 ? "ok" : "ERROR")));
        }
        BlockSequence effectiveList = new BlockSequence(blockList.getStartOn(), blockList.getDisplayAlign());
        effectiveList.addAll(this.getCurrentChildLM().getChangedKnuthElements(blockList.subList(0, blockList.size() - blockList.ignoreAtEnd), 0));
        effectiveList.endSequence();
        ElementListObserver.observe(effectiveList, "breaker-effective", null);
        alg.getPageBreaks().clear();
        return effectiveList;
    }

    private int adjustBlockSpaces(LinkedList spaceList, int difference, int total) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustBlockSpaces: difference " + difference + " / " + total + " on " + spaceList.size() + " spaces in block"));
        }
        ListIterator spaceListIterator = spaceList.listIterator();
        int adjustedDiff = 0;
        int partial = 0;
        while (spaceListIterator.hasNext()) {
            KnuthGlue blockSpace = (KnuthGlue)spaceListIterator.next();
            partial += difference > 0 ? blockSpace.getStretch() : blockSpace.getShrink();
            if (log.isDebugEnabled()) {
                log.debug((Object)("available = " + partial + " / " + total));
                log.debug((Object)("competenza  = " + ((int)((float)partial * (float)difference / (float)total) - adjustedDiff) + " / " + difference));
            }
            int newAdjust = ((BlockLevelLayoutManager)blockSpace.getLayoutManager()).negotiateBPDAdjustment((int)((float)partial * (float)difference / (float)total) - adjustedDiff, blockSpace);
            adjustedDiff += newAdjust;
        }
        return adjustedDiff;
    }

    private int adjustLineNumbers(LinkedList lineList, int difference, int total) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustLineNumbers: difference " + difference + " / " + total + " on " + lineList.size() + " elements"));
        }
        ListIterator lineListIterator = lineList.listIterator();
        int adjustedDiff = 0;
        int partial = 0;
        while (lineListIterator.hasNext()) {
            KnuthGlue line = (KnuthGlue)lineListIterator.next();
            int newAdjust = ((BlockLevelLayoutManager)line.getLayoutManager()).negotiateBPDAdjustment((int)((float)(partial += difference > 0 ? line.getStretch() : line.getShrink()) * (float)difference / (float)total) - adjustedDiff, line);
            adjustedDiff += newAdjust;
        }
        return adjustedDiff;
    }

    public class BlockSequence
    extends BlockKnuthSequence {
        public int ignoreAtStart = 0;
        public int ignoreAtEnd = 0;
        private int startOn;
        private int displayAlign;

        public BlockSequence(int startOn, int displayAlign) {
            this.startOn = startOn;
            this.displayAlign = displayAlign;
        }

        public int getStartOn() {
            return this.startOn;
        }

        public int getDisplayAlign() {
            return this.displayAlign;
        }

        public KnuthSequence endSequence() {
            return this.endSequence(null);
        }

        public KnuthSequence endSequence(Position breakPosition) {
            while (this.size() > this.ignoreAtStart && !((KnuthElement)ListUtil.getLast(this)).isBox()) {
                ListUtil.removeLast(this);
            }
            if (this.size() > this.ignoreAtStart) {
                if (this.getDisplayAlign() == 163 && AbstractBreaker.this.isSinglePartFavored()) {
                    this.add(new KnuthPenalty(0, -1000, false, breakPosition, false));
                    this.ignoreAtEnd = 1;
                } else {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(0, 10000000, 0, null, false));
                    this.add(new KnuthPenalty(0, -1000, false, breakPosition, false));
                    this.ignoreAtEnd = 3;
                }
                return this;
            }
            this.clear();
            return null;
        }

        public BlockSequence endBlockSequence(Position breakPosition) {
            KnuthSequence temp = this.endSequence(breakPosition);
            if (temp != null) {
                BlockSequence returnSequence = new BlockSequence(this.startOn, this.displayAlign);
                returnSequence.addAll(temp);
                returnSequence.ignoreAtEnd = this.ignoreAtEnd;
                return returnSequence;
            }
            return null;
        }
    }

    public static class PageBreakPosition
    extends LeafPosition {
        double bpdAdjust;
        int difference;
        int footnoteFirstListIndex;
        int footnoteFirstElementIndex;
        int footnoteLastListIndex;
        int footnoteLastElementIndex;

        PageBreakPosition(LayoutManager lm, int breakIndex, int ffli, int ffei, int flli, int flei, double bpdA, int diff) {
            super(lm, breakIndex);
            this.bpdAdjust = bpdA;
            this.difference = diff;
            this.footnoteFirstListIndex = ffli;
            this.footnoteFirstElementIndex = ffei;
            this.footnoteLastListIndex = flli;
            this.footnoteLastElementIndex = flei;
        }
    }
}

