/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.inotify;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MissingEventsException
extends Exception {
    private static final long serialVersionUID = 1L;
    private long expectedTxid;
    private long actualTxid;

    public MissingEventsException() {
    }

    public MissingEventsException(long expectedTxid, long actualTxid) {
        this.expectedTxid = expectedTxid;
        this.actualTxid = actualTxid;
    }

    public long getExpectedTxid() {
        return this.expectedTxid;
    }

    public long getActualTxid() {
        return this.actualTxid;
    }

    @Override
    public String toString() {
        return "We expected the next batch of events to start with transaction ID " + this.expectedTxid + ", but it instead started with transaction ID " + this.actualTxid + ". Most likely the intervening transactions were cleaned " + "up as part of checkpointing.";
    }
}

