/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.ArrayList;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.AttributesImpl;

public class ConfigurationParameterDeclarations_impl
extends MetaDataObject_impl
implements ConfigurationParameterDeclarations {
    static final long serialVersionUID = -2248322904617280983L;
    private ConfigurationParameter[] mConfigurationParameters = new ConfigurationParameter[0];
    private ConfigurationGroup[] mConfigurationGroups = new ConfigurationGroup[0];
    private ConfigurationParameter[] mCommonParameters = new ConfigurationParameter[0];
    private String mDefaultGroupName;
    private String mSearchStrategy;

    @Override
    public ConfigurationParameter[] getConfigurationParameters() {
        return this.mConfigurationParameters;
    }

    @Override
    public void setConfigurationParameters(ConfigurationParameter[] aParams) {
        if (aParams == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aParams", "setConfigurationParameters"});
        }
        this.mConfigurationParameters = aParams;
    }

    @Override
    public ConfigurationParameter[] getCommonParameters() {
        return this.mCommonParameters;
    }

    @Override
    public ConfigurationGroup[] getConfigurationGroups() {
        return this.mConfigurationGroups;
    }

    @Override
    public String getDefaultGroupName() {
        return this.mDefaultGroupName;
    }

    @Override
    public String getSearchStrategy() {
        return this.mSearchStrategy;
    }

    @Override
    public void setCommonParameters(ConfigurationParameter[] aParams) {
        if (aParams == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aParams", "setCommonParameters"});
        }
        this.mCommonParameters = aParams;
    }

    @Override
    public void setConfigurationGroups(ConfigurationGroup[] aGroups) {
        if (aGroups == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aGroups", "setConfigurationGroups"});
        }
        this.mConfigurationGroups = aGroups;
    }

    @Override
    public void setDefaultGroupName(String aGroupName) {
        this.mDefaultGroupName = aGroupName;
    }

    @Override
    public void setSearchStrategy(String aStrategy) {
        this.mSearchStrategy = aStrategy;
    }

    @Override
    public ConfigurationParameter getConfigurationParameter(String aGroupName, String aParamName) {
        if (aGroupName == null) {
            ConfigurationParameter[] params = this.getConfigurationParameters();
            return this._getConfigurationParameter(params, aParamName);
        }
        ConfigurationParameter[] commonParams = this.getCommonParameters();
        ConfigurationParameter p = this._getConfigurationParameter(commonParams, aParamName);
        if (p == null) {
            ConfigurationParameter[] paramsInGroup;
            ConfigurationGroup[] groups = this.getConfigurationGroupDeclarations(aGroupName);
            for (int i = 0; i < groups.length && (p = this._getConfigurationParameter(paramsInGroup = groups[i].getConfigurationParameters(), aParamName)) == null; ++i) {
            }
        }
        return p;
    }

    @Override
    public ConfigurationGroup[] getConfigurationGroupDeclarations(String aGroupName) {
        ArrayList<ConfigurationGroup> results = new ArrayList<ConfigurationGroup>();
        ConfigurationGroup[] grps = this.getConfigurationGroups();
        if (grps != null) {
            block0: for (int i = 0; i < grps.length; ++i) {
                String[] names = grps[i].getNames();
                for (int j = 0; j < names.length; ++j) {
                    if (!aGroupName.equals(names[j])) continue;
                    results.add(grps[i]);
                    continue block0;
                }
            }
        }
        ConfigurationGroup[] resultArr = new ConfigurationGroup[results.size()];
        results.toArray(resultArr);
        return resultArr;
    }

    @Override
    public void addConfigurationParameter(ConfigurationParameter aConfigurationParameter) {
        ConfigurationParameter[] current = this.getConfigurationParameters();
        ConfigurationParameter[] newArr = new ConfigurationParameter[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aConfigurationParameter;
        this.setConfigurationParameters(newArr);
    }

    @Override
    public void removeConfigurationParameter(ConfigurationParameter aConfigurationParameter) {
        ConfigurationParameter[] current = this.getConfigurationParameters();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aConfigurationParameter) continue;
            ConfigurationParameter[] newArr = new ConfigurationParameter[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setConfigurationParameters(newArr);
            break;
        }
    }

    @Override
    public void addCommonParameter(ConfigurationParameter aConfigurationParameter) {
        ConfigurationParameter[] current = this.getCommonParameters();
        ConfigurationParameter[] newArr = new ConfigurationParameter[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aConfigurationParameter;
        this.setCommonParameters(newArr);
    }

    @Override
    public void removeCommonParameter(ConfigurationParameter aConfigurationParameter) {
        ConfigurationParameter[] current = this.getCommonParameters();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aConfigurationParameter) continue;
            ConfigurationParameter[] newArr = new ConfigurationParameter[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setCommonParameters(newArr);
            break;
        }
    }

    @Override
    public void addConfigurationGroup(ConfigurationGroup aConfigurationGroup) {
        ConfigurationGroup[] current = this.getConfigurationGroups();
        ConfigurationGroup[] newArr = new ConfigurationGroup[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aConfigurationGroup;
        this.setConfigurationGroups(newArr);
    }

    @Override
    public void removeConfigurationGroup(ConfigurationGroup aConfigurationGroup) {
        ConfigurationGroup[] current = this.getConfigurationGroups();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aConfigurationGroup) continue;
            ConfigurationGroup[] newArr = new ConfigurationGroup[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setConfigurationGroups(newArr);
            break;
        }
    }

    protected ConfigurationParameter _getConfigurationParameter(ConfigurationParameter[] aParams, String aName) {
        if (aParams != null) {
            for (int i = 0; i < aParams.length; ++i) {
                if (!aName.equals(aParams[i].getName())) continue;
                return aParams[i];
            }
        }
        return null;
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String defaultGroup = aElement.getAttribute("defaultGroup");
        if (defaultGroup.length() > 0) {
            this.setDefaultGroupName(defaultGroup);
        } else {
            this.setDefaultGroupName(null);
        }
        String searchStrategy = aElement.getAttribute("searchStrategy");
        if (searchStrategy.length() > 0) {
            this.setSearchStrategy(searchStrategy);
        } else {
            this.setSearchStrategy(null);
        }
        ArrayList<XMLizable> params = new ArrayList<XMLizable>();
        ArrayList<XMLizable> groups = new ArrayList<XMLizable>();
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("configurationParameter".equals(elem.getTagName())) {
                params.add(aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("commonParameters".equals(elem.getTagName())) {
                PropertyXmlInfo commonParametersPropInfo = new PropertyXmlInfo("commonParameters");
                this.readPropertyValueFromXMLElement(commonParametersPropInfo, elem, aParser, aOptions);
                continue;
            }
            if ("configurationGroup".equals(elem.getTagName())) {
                groups.add(aParser.buildObject(elem, aOptions));
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
        ConfigurationParameter[] paramArr = new ConfigurationParameter[params.size()];
        params.toArray(paramArr);
        this.setConfigurationParameters(paramArr);
        ConfigurationGroup[] groupArr = new ConfigurationGroup[groups.size()];
        groups.toArray(groupArr);
        this.setConfigurationGroups(groupArr);
    }

    protected String getXMLAttributeString() {
        StringBuffer buf = new StringBuffer();
        if (this.getDefaultGroupName() != null) {
            buf.append("defaultGroup = \"");
            buf.append(this.getDefaultGroupName());
            buf.append('\"');
        }
        if (this.getSearchStrategy() != null) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("searchStrategy = \"");
            buf.append(this.getSearchStrategy());
            buf.append('\"');
        }
        return buf.toString();
    }

    @Override
    protected AttributesImpl getXMLAttributes() {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getDefaultGroupName() != null && !this.getDefaultGroupName().equals("")) {
            attrs.addAttribute("", "defaultGroup", "defaultGroup", "string", this.getDefaultGroupName());
        }
        if (this.getSearchStrategy() != null && !this.getSearchStrategy().equals("")) {
            attrs.addAttribute("", "searchStrategy", "searchStrategy", "string", this.getSearchStrategy());
        }
        return attrs;
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("configurationParameters", new PropertyXmlInfo[]{new PropertyXmlInfo("configurationParameters", null), new PropertyXmlInfo("commonParameters", "commonParameters"), new PropertyXmlInfo("configurationGroups", null)});
    }
}

