/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.SqlBindParser;

public class SimpleQueryExecutor {
    private PreparedStatement _stmt = null;
    private ResultSet _rset = null;

    public SimpleQueryExecutor(Database database) {
    }

    public QueryResults execute(Connection conn, QueryExpression expr, Object[] bindValues) throws QueryException {
        try {
            String pre_sql = expr.getStatement(false);
            String sql = SqlBindParser.getJdbcSql(pre_sql);
            this._stmt = conn.prepareStatement(sql);
            if (bindValues != null) {
                SqlBindParser.bindJdbcValues(this._stmt, pre_sql, bindValues);
            }
            this._rset = this._stmt.executeQuery();
            return new SimpleQueryResults();
        }
        catch (SQLException s) {
            if (this._rset != null) {
                try {
                    this._rset.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            this._rset = null;
            this._stmt = null;
            throw new QueryException(s.toString());
        }
    }

    public class SimpleQueryResults
    implements QueryResults {
        private boolean _hasMore = false;

        public SimpleQueryResults() {
            try {
                this._hasMore = SimpleQueryExecutor.this._rset.next();
            }
            catch (SQLException e) {
                this._hasMore = false;
            }
        }

        public boolean absolute(int row) throws PersistenceException {
            boolean retval = false;
            try {
                if (SimpleQueryExecutor.this._rset != null) {
                    retval = SimpleQueryExecutor.this._rset.absolute(row);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException(e.getMessage());
            }
            return retval;
        }

        public int size() throws PersistenceException {
            int whereIAm = 1;
            int retval = 0;
            try {
                if (SimpleQueryExecutor.this._rset != null) {
                    whereIAm = SimpleQueryExecutor.this._rset.getRow();
                    retval = SimpleQueryExecutor.this._rset.last() ? SimpleQueryExecutor.this._rset.getRow() : 0;
                    if (whereIAm > 0) {
                        SimpleQueryExecutor.this._rset.absolute(whereIAm);
                    } else {
                        SimpleQueryExecutor.this._rset.beforeFirst();
                    }
                }
            }
            catch (SQLException se) {
                throw new PersistenceException(se.getMessage());
            }
            return retval;
        }

        public boolean hasMoreElements() {
            return this._hasMore;
        }

        public boolean hasMore() throws PersistenceException {
            return this._hasMore;
        }

        public Object nextElement() throws NoSuchElementException {
            try {
                return this.next(true);
            }
            catch (PersistenceException except) {
                return null;
            }
        }

        public Object next() throws PersistenceException, NoSuchElementException {
            return this.next(false);
        }

        private Object next(boolean skipError) throws PersistenceException, NoSuchElementException {
            Object retVal;
            block3: {
                retVal = null;
                if (!this._hasMore) {
                    throw new NoSuchElementException();
                }
                try {
                    retVal = SimpleQueryExecutor.this._rset.getObject(1);
                    this._hasMore = SimpleQueryExecutor.this._rset.next();
                }
                catch (SQLException except) {
                    if (skipError) break block3;
                    throw new PersistenceException(except.toString());
                }
            }
            return retVal;
        }

        public void close() {
            if (SimpleQueryExecutor.this._rset != null) {
                try {
                    SimpleQueryExecutor.this._rset.close();
                }
                catch (SQLException s) {
                    // empty catch block
                }
            }
            if (SimpleQueryExecutor.this._stmt != null) {
                try {
                    SimpleQueryExecutor.this._stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            SimpleQueryExecutor.this._rset = null;
            SimpleQueryExecutor.this._stmt = null;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

